/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.SubgraphSelection;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.util.InternalClipboard;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;

class PasteSubgraphAction
extends AbstractAction
implements ClipboardOwner {
    private GraphEditable graphEditor;

    public PasteSubgraphAction(GraphEditable graphEditor) {
        super("Paste");
        if (graphEditor == null) {
            throw new NullPointerException("Desktop must not be null.");
        }
        this.graphEditor = graphEditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transferable transferable = InternalClipboard.getInstance().getContents(null);
        if (!(transferable instanceof SubgraphSelection)) {
            return;
        }
        SubgraphSelection selection = (SubgraphSelection)transferable;
        DataFlavor flavor = new DataFlavor(SubgraphSelection.class, "Subgraph Selection");
        try {
            List modelList = (List)selection.getTransferData(flavor);
            Point point = EditorUtils.getTopLeftPoint(modelList);
            point.translate(50, 50);
            this.graphEditor().pasteSubsession(modelList, point);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private GraphEditable graphEditor() {
        return this.graphEditor;
    }
}

