/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PatternDisplay
extends JPanel
implements GraphEditable {
    private GraphWorkbench workbench;

    public PatternDisplay(final Graph graph) {
        final List<Graph> dags = MbUtils.generatePatternDags(graph, false);
        if (dags.size() == 0) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There are no consistent DAG's.");
            return;
        }
        Graph dag = dags.get(0);
        this.workbench = new GraphWorkbench(dag);
        final SpinnerNumberModel model = new SpinnerNumberModel(1, 1, dags.size(), 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = model.getNumber().intValue();
                PatternDisplay.this.workbench.setGraph((Graph)dags.get(index - 1));
            }
        });
        final JSpinner spinner = new JSpinner();
        JComboBox<String> orient = new JComboBox<String>(new String[]{"Orient --- only", "Orient ---, <->"});
        spinner.setModel(model);
        final JLabel totalLabel = new JLabel(" of " + dags.size());
        orient.setMaximumSize(orient.getPreferredSize());
        orient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                String option = (String)box.getSelectedItem();
                if ("Orient --- only".equals(option)) {
                    List<Graph> _dags = MbUtils.generatePatternDags(graph, false);
                    dags.clear();
                    dags.addAll(_dags);
                    final SpinnerNumberModel model = new SpinnerNumberModel(1, 1, dags.size(), 1);
                    model.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            int index = model.getNumber().intValue();
                            PatternDisplay.this.workbench.setGraph((Graph)dags.get(index - 1));
                        }
                    });
                    spinner.setModel(model);
                    totalLabel.setText(" of " + dags.size());
                    PatternDisplay.this.workbench.setGraph((Graph)dags.get(0));
                } else if ("Orient ---, <->".equals(option)) {
                    List<Graph> _dags = MbUtils.generatePatternDags(graph, true);
                    dags.clear();
                    dags.addAll(_dags);
                    final SpinnerNumberModel model = new SpinnerNumberModel(1, 1, dags.size(), 1);
                    model.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            int index = model.getNumber().intValue();
                            PatternDisplay.this.workbench.setGraph((Graph)dags.get(index - 1));
                        }
                    });
                    spinner.setModel(model);
                    totalLabel.setText(" of " + dags.size());
                    PatternDisplay.this.workbench.setGraph((Graph)dags.get(0));
                }
            }
        });
        spinner.setPreferredSize(new Dimension(50, 20));
        spinner.setMaximumSize(spinner.getPreferredSize());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(orient);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("DAG "));
        b1.add(spinner);
        b1.add(totalLabel);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.workbench);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        graphPanel.add(jScrollPane);
        graphPanel.setBorder(new TitledBorder("DAG in Pattern"));
        b2.add(graphPanel);
        b.add(b2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.menuBar(), "North");
        this.add((Component)b, "Center");
    }

    @Override
    public List getSelectedModelComponents() {
        Component[] components = this.getWorkbench().getComponents();
        ArrayList<TetradSerializable> selectedModelComponents = new ArrayList<TetradSerializable>();
        for (Component comp : components) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (int i = 0; i < sessionElements.size(); ++i) {
            Object o = sessionElements.get(i);
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        this.workbench.setGraph(graph);
    }

    private JMenuBar menuBar() {
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        edit.add(copy);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(edit);
        return menuBar;
    }
}

