/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;

public class SaveGraph
extends AbstractAction {
    private GraphEditable graphEditable;
    private String title = "";
    private boolean xml;

    public SaveGraph(GraphEditable graphEditable, String title, boolean xml) {
        super(title);
        this.title = title;
        this.xml = xml;
        if (this.title == null) {
            this.title = "Save";
        }
        if (graphEditable == null) {
            throw new NullPointerException("Component must not be null.");
        }
        this.graphEditable = graphEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Graph graph = this.getGraphEditable().getGraph();
        Component parent = (Component)((Object)this.getGraphEditable());
        if (this.xml) {
            File file = EditorUtils.getSaveFile("graph", "xml", parent, false, this.title);
            PrintWriter out = GraphUtils.saveGraph(graph, file, true);
            Preferences.userRoot().put("fileSaveLocation", file.getParent());
            out.close();
        } else {
            File file = EditorUtils.getSaveFile("graph", "txt", parent, false, this.title);
            PrintWriter out = GraphUtils.saveGraph(graph, file, false);
            Preferences.userRoot().put("fileSaveLocation", file.getParent());
            out.close();
        }
    }

    private GraphEditable getGraphEditable() {
        return this.graphEditable;
    }
}

