/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class SaveKnowledgeAction
extends AbstractAction {
    private KnowledgeEditable knowledgeEditable;

    public SaveKnowledgeAction(KnowledgeEditable knowledgeEditable) {
        super("Save Knowledge...");
        if (knowledgeEditable == null) {
            throw new NullPointerException();
        }
        this.knowledgeEditable = knowledgeEditable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component comp = this.knowledgeEditable instanceof Component ? (Component)((Object)this.knowledgeEditable) : null;
        File file = EditorUtils.getSaveFile("knowledge", "txt", comp, false, "Save Knowledge...");
        if (file != null) {
            try {
                FileWriter writer = new FileWriter(file);
                Knowledge knowledge = this.knowledgeEditable.getKnowledge();
                Knowledge.saveKnowledge(knowledge, writer);
                writer.close();
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Saved knowledge as " + file.getAbsoluteFile() + ".");
            }
            catch (IOException e1) {
                String message = e1.getMessage() == null ? e1.getClass().getName() : e1.getMessage();
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), message);
            }
        }
    }
}

