/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GaParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public final class SearchGaParamEditor
extends JPanel
implements ParameterEditor {
    private GaParams params;
    private Object[] parentModels;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (GaParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null) {
            throw new NullPointerException();
        }
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        int i;
        ArrayList<String> varNames;
        DoubleTextField alphaField = new DoubleTextField(this.params.getAlpha(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (value < 0.0 || value > 1.0) {
                    return oldValue;
                }
                SearchGaParamEditor.this.params.setAlpha(value);
                return value;
            }
        });
        DoubleTextField biasField = new DoubleTextField(this.params.getBias(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        biasField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (value < 0.0 || value > 1.0) {
                    return oldValue;
                }
                SearchGaParamEditor.this.params.setBias(value);
                return value;
            }
        });
        DoubleTextField timeField = new DoubleTextField(this.params.getTimeLimit(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        timeField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (value < 0.0 || value > 1.0) {
                    return oldValue;
                }
                SearchGaParamEditor.this.params.setTimeLimit(value);
                return value;
            }
        });
        VariableSource dataModel = null;
        Graph graph = null;
        for (Object parentModel : this.parentModels) {
            if (parentModel instanceof DataWrapper) {
                DataWrapper dataWrapper = (DataWrapper)parentModel;
                dataModel = dataWrapper.getSelectedDataModel();
            }
            if (!(parentModel instanceof Graph)) continue;
            graph = (Graph)parentModel;
        }
        if (dataModel != null) {
            varNames = new ArrayList<String>(dataModel.getVariableNames());
            System.out.println("var names = " + varNames);
        } else if (graph != null) {
            Iterator<Node> it = graph.getNodes().iterator();
            varNames = new ArrayList();
            while (it.hasNext()) {
                Node temp = it.next();
                if (temp.getNodeType() != NodeType.MEASURED) continue;
                varNames.add(temp.getName());
            }
            System.out.println("var names = " + varNames);
        } else {
            System.out.println("Null Data Model");
        }
        biasField.setValue(1.0);
        timeField.setValue(0.0);
        Color backgroundColor = super.getBackground();
        this.setBackground(backgroundColor);
        this.setBorder(new MatteBorder(10, 10, 10, 10, backgroundColor));
        this.setLayout(new BoxLayout(this, 1));
        JPanel[] rows = new JPanel[9];
        for (i = 0; i < 9; ++i) {
            rows[i] = new JPanel();
        }
        for (i = 0; i < 3; ++i) {
            rows[i].setLayout(new FlowLayout(0));
            rows[i].setMaximumSize(new Dimension(1000, 20));
        }
        String msg0 = "Alpha Value:";
        rows[1].setLayout(new FlowLayout(0));
        rows[1].setMaximumSize(new Dimension(1000, 20));
        rows[1].add(new JLabel(msg0));
        rows[1].add(alphaField);
        this.add(rows[1]);
        JButton knowledgeButton = new JButton("View Forbiden/Required Edgelist");
        rows[2] = new JPanel();
        rows[2].setBackground(backgroundColor);
        rows[2].setLayout(new FlowLayout(0));
        rows[2].add(knowledgeButton);
        this.add(rows[2]);
        String msg1 = "Scoring Bias (1.0 default): ";
        rows[3] = new JPanel();
        rows[3].add(new JLabel(msg1));
        rows[3].add(biasField);
        rows[3].setBackground(backgroundColor);
        rows[3].setLayout(new FlowLayout(0));
        this.add(rows[3]);
        String msg2 = "Time Limit(minutes): ";
        rows[4] = new JPanel();
        rows[4].add(new JLabel(msg2));
        rows[4].add(timeField);
        rows[4].setBackground(backgroundColor);
        rows[4].setLayout(new FlowLayout(0));
        this.add(rows[4]);
        knowledgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchGaParamEditor.this.openKnowledgeEditor();
            }
        });
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private void openKnowledgeEditor() {
        if (this.getParams() == null) {
            throw new NullPointerException("Parameter object must not be null if you want to launch a OldKnowledgeEditor.");
        }
        Knowledge knowledge = this.getParams().getKnowledge();
        List<String> varNames = this.getParams().getVarNames();
        Graph sourceGraph = this.getParams().getSourceGraph();
        KnowledgeEditor knowledgeEditor = new KnowledgeEditor(knowledge, varNames, sourceGraph);
        EditorWindow window = new EditorWindow(knowledgeEditor, knowledgeEditor.getName(), "Save", false, this);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private SearchParams getParams() {
        return this.params;
    }
}

