/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.Sem2DataParams;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Sem2DataParamsEditor
extends JPanel
implements ParameterEditor {
    private Sem2DataParams params = null;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (Sem2DataParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        IntTextField sampleSizeField = new IntTextField(this.getParams().getSampleSize(), 4);
        sampleSizeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    Sem2DataParamsEditor.this.getParams().setSampleSize(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        JCheckBox latentVarsBox = new JCheckBox("Include Latent Variables");
        latentVarsBox.setHorizontalTextPosition(2);
        latentVarsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                Sem2DataParamsEditor.this.getParams().setIncludeLatents(b.isSelected());
            }
        });
        JCheckBox positiveOnlyBox = new JCheckBox("Positive Data Only");
        positiveOnlyBox.setHorizontalTextPosition(2);
        positiveOnlyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                Sem2DataParamsEditor.this.getParams().setPositiveDataOnly(b.isSelected());
            }
        });
        this.setLayout(new BorderLayout());
        Box b6 = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Sample size:  "));
        b1.add(Box.createHorizontalGlue());
        b1.add(sampleSizeField);
        Box b2 = Box.createHorizontalBox();
        b2.add(latentVarsBox);
        b2.add(Box.createHorizontalGlue());
        Box b3 = Box.createHorizontalBox();
        b3.add(positiveOnlyBox);
        b3.add(Box.createHorizontalGlue());
        b6.add(b1);
        b6.add(Box.createVerticalGlue());
        this.add((Component)b6, "Center");
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private synchronized Sem2DataParams getParams() {
        return this.params;
    }
}

