/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.ImpliedMatricesPanel;
import edu.cmu.tetradapp.editor.ModelStatisticsPanel;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SemImGraphicalEditor;
import edu.cmu.tetradapp.editor.SemImTabularEditor;
import edu.cmu.tetradapp.model.PValueImproverWrapper;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class SemImEditor
extends JPanel
implements LayoutEditable {
    private ISemIm semIm;
    private SemImGraphicalEditor semImGraphicalEditor;
    private SemImTabularEditor semImTabularEditor;
    private ImpliedMatricesPanel impliedMatricesPanel;
    private ModelStatisticsPanel modelStatisticsPanel;
    private int maxFreeParamsForStatistics = 200;
    private boolean editCovariancesAsCorrelations = false;
    private boolean editIntercepts = false;
    private JTabbedPane tabbedPane;
    private String graphicalEditorTitle = "Graphical Editor";
    private String tabularEditorTitle = "TabularEditor";
    private boolean editable = true;
    private int matrixSelection = 0;
    private JCheckBoxMenuItem meansItem;
    private JCheckBoxMenuItem interceptsItem;
    private JMenuItem errorTerms;

    public SemImEditor(ISemIm semIm) {
        this(semIm, "Graphical Editor", "Tabular Editor");
    }

    public SemImEditor(SemIm semIm) {
        this((ISemIm)semIm);
    }

    public SemImEditor(ISemIm semIm, String graphicalEditorTitle, String tabularEditorTitle) {
        if (semIm == null) {
            throw new NullPointerException("The SEM IM has not been specified.");
        }
        this.checkForUnmeasuredLatents(semIm);
        this.semIm = semIm;
        this.graphicalEditorTitle = graphicalEditorTitle;
        this.tabularEditorTitle = tabularEditorTitle;
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(graphicalEditorTitle, this.graphicalEditor());
        this.tabbedPane.add(tabularEditorTitle, this.tabularEditor());
        this.tabbedPane.add("Implied Matrices", this.impliedMatricesPanel());
        this.tabbedPane.add("Model Statistics", this.modelStatisticsPanel());
        this.add((Component)this.tabbedPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.semImGraphicalEditor.getWorkbench(), "Save Graph Image..."));
        file.add(this.getCopyMatrixMenuItem());
        JCheckBoxMenuItem covariances = new JCheckBoxMenuItem("Show standard deviations");
        JCheckBoxMenuItem correlations = new JCheckBoxMenuItem("Show correlations");
        ButtonGroup correlationGroup = new ButtonGroup();
        correlationGroup.add(covariances);
        correlationGroup.add(correlations);
        covariances.setSelected(true);
        covariances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SemImEditor.this.setEditCovariancesAsCorrelations(false);
            }
        });
        correlations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SemImEditor.this.setEditCovariancesAsCorrelations(true);
            }
        });
        this.errorTerms = new JMenuItem();
        if (this.getSemGraph().isShowErrorTerms()) {
            this.errorTerms.setText("Hide Error Terms");
        } else {
            this.errorTerms.setText("Show Error Terms");
        }
        this.errorTerms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                if ("Hide Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Show Error Terms");
                    SemImEditor.this.getSemGraph().setShowErrorTerms(false);
                    SemImEditor.this.graphicalEditor().resetLabels();
                } else if ("Show Error Terms".equals(menuItem.getText())) {
                    menuItem.setText("Hide Error Terms");
                    SemImEditor.this.getSemGraph().setShowErrorTerms(true);
                    SemImEditor.this.graphicalEditor().resetLabels();
                }
            }
        });
        this.meansItem = new JCheckBoxMenuItem("Show means");
        this.interceptsItem = new JCheckBoxMenuItem("Show intercepts");
        ButtonGroup meansGroup = new ButtonGroup();
        meansGroup.add(this.meansItem);
        meansGroup.add(this.interceptsItem);
        this.meansItem.setSelected(true);
        this.meansItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SemImEditor.this.setEditIntercepts(false);
            }
        });
        this.interceptsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SemImEditor.this.setEditIntercepts(true);
            }
        });
        JMenu params = new JMenu("Parameters");
        params.add(this.errorTerms);
        params.addSeparator();
        params.add(covariances);
        params.add(correlations);
        params.addSeparator();
        if (!semIm.isCyclic()) {
            params.add(this.meansItem);
            params.add(this.interceptsItem);
        }
        menuBar.add(params);
        menuBar.add(new LayoutMenu(this));
        this.add((Component)menuBar, "North");
    }

    @Override
    public Graph getGraph() {
        return this.semImGraphicalEditor.getWorkbench().getGraph();
    }

    @Override
    public Knowledge getKnowledge() {
        return this.semImGraphicalEditor.getWorkbench().getKnowledge();
    }

    @Override
    public Graph getSourceGraph() {
        return this.semImGraphicalEditor.getWorkbench().getSourceGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        SemGraph _graph = (SemGraph)this.semImGraphicalEditor.getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.semImGraphicalEditor.getWorkbench().layoutByGraph(graph);
        _graph.resetErrorPositions();
        this.semImGraphicalEditor.getWorkbench().setGraph(_graph);
        this.errorTerms.setText("Show Error Terms");
    }

    @Override
    public void layoutByKnowledge() {
        SemGraph _graph = (SemGraph)this.semImGraphicalEditor.getWorkbench().getGraph();
        _graph.setShowErrorTerms(false);
        this.semImGraphicalEditor.getWorkbench().layoutByKnowledge();
        _graph.resetErrorPositions();
        this.semImGraphicalEditor.getWorkbench().setGraph(_graph);
        this.errorTerms.setText("Show Error Terms");
    }

    private void checkForUnmeasuredLatents(ISemIm semIm) {
        List<Node> unmeasuredLatents = semIm.listUnmeasuredLatents();
        if (!unmeasuredLatents.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("This model has the following latent(s) without measured children: ");
            for (int i = 0; i < unmeasuredLatents.size(); ++i) {
                buf.append(unmeasuredLatents.get(i));
                if (i >= unmeasuredLatents.size() - 1) continue;
                buf.append(", ");
            }
            buf.append(".\nAs a result, standard errors for non-mean parameters cannot be calculated.");
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), buf.toString(), "FYI", 1);
        }
    }

    private SemGraph getSemGraph() {
        return this.semIm.getSemPm().getGraph();
    }

    public SemImEditor(SemImWrapper semImWrapper) {
        this(semImWrapper.getSemIm());
    }

    public SemImEditor(SemEstimatorWrapper semEstWrapper) {
        this(semEstWrapper.getSemEstimator().getEstimatedSem());
    }

    public SemImEditor(PValueImproverWrapper runner) {
        this(runner.getEstSem());
        runner.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graph".equals(evt.getPropertyName())) {
                    Graph graph = (Graph)evt.getNewValue();
                    SemImEditor.this.semImGraphicalEditor.getWorkbench().setGraph(graph);
                }
            }
        });
    }

    public int getTabSelectionIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public int getMatrixSelection() {
        return this.impliedMatricesPanel().getMatrixSelection();
    }

    public void setSemIm(SemIm semIm, int tabSelectionIndex, int matrixSelection) {
        if (semIm == null) {
            throw new NullPointerException();
        }
        if (tabSelectionIndex < 0 || tabSelectionIndex >= 4) {
            throw new IllegalArgumentException("Tab selection must be 0, 1, 2, or 3: " + tabSelectionIndex);
        }
        if (matrixSelection < 0 || matrixSelection >= 4) {
            throw new IllegalArgumentException("Matrix selection must be 0, 1, 2, or 3: " + matrixSelection);
        }
        SemGraph oldGraph = this.semIm.getSemPm().getGraph();
        this.semIm = semIm;
        GraphUtils.arrangeBySourceGraph(semIm.getSemPm().getGraph(), oldGraph);
        this.matrixSelection = matrixSelection;
        this.impliedMatricesPanel().setMatrixSelection(matrixSelection);
        this.semImGraphicalEditor = null;
        this.semImTabularEditor = null;
        this.impliedMatricesPanel = null;
        this.modelStatisticsPanel = null;
        this.tabbedPane.removeAll();
        this.tabbedPane.add(this.getGraphicalEditorTitle(), this.graphicalEditor());
        this.tabbedPane.add(this.getTabularEditorTitle(), this.tabularEditor());
        this.tabbedPane.add("Implied Matrices", this.impliedMatricesPanel());
        this.tabbedPane.add("Model Statistics", this.modelStatisticsPanel());
        this.tabbedPane.setSelectedIndex(tabSelectionIndex);
        this.tabbedPane.validate();
    }

    private JMenuItem getCopyMatrixMenuItem() {
        JMenuItem item = new JMenuItem("Copy Implied Covariance Matrix");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = SemImEditor.this.impliedMatricesPanel.getMatrixInTabDelimitedForm();
                Clipboard board = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(s);
                board.setContents(selection, selection);
            }
        });
        return item;
    }

    private ISemIm getSemIm() {
        return this.semIm;
    }

    private SemImGraphicalEditor graphicalEditor() {
        if (this.semImGraphicalEditor == null) {
            this.semImGraphicalEditor = new SemImGraphicalEditor(this.getSemIm(), this, this.maxFreeParamsForStatistics);
            this.semImGraphicalEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SemImEditor.this.firePropertyChange(evt.getPropertyName(), null, null);
                }
            });
        }
        return this.semImGraphicalEditor;
    }

    private SemImTabularEditor tabularEditor() {
        if (this.semImTabularEditor == null) {
            this.semImTabularEditor = new SemImTabularEditor(this.getSemIm(), this, this.maxFreeParamsForStatistics);
        }
        this.semImTabularEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SemImEditor.this.firePropertyChange(evt.getPropertyName(), null, null);
            }
        });
        return this.semImTabularEditor;
    }

    private ImpliedMatricesPanel impliedMatricesPanel() {
        if (this.impliedMatricesPanel == null) {
            this.impliedMatricesPanel = new ImpliedMatricesPanel(this.getSemIm(), this.matrixSelection);
        }
        return this.impliedMatricesPanel;
    }

    private ModelStatisticsPanel modelStatisticsPanel() {
        if (this.modelStatisticsPanel == null) {
            this.modelStatisticsPanel = new ModelStatisticsPanel(this.getSemIm());
        }
        return this.modelStatisticsPanel;
    }

    public boolean isEditCovariancesAsCorrelations() {
        return this.editCovariancesAsCorrelations;
    }

    private void setEditCovariancesAsCorrelations(boolean editCovariancesAsCorrelations) {
        this.editCovariancesAsCorrelations = editCovariancesAsCorrelations;
        this.graphicalEditor().resetLabels();
        this.tabularEditor().getTableModel().fireTableDataChanged();
    }

    public boolean isEditIntercepts() {
        return this.editIntercepts;
    }

    public void setEditIntercepts(boolean editIntercepts) {
        this.editIntercepts = editIntercepts;
        this.graphicalEditor().resetLabels();
        this.tabularEditor().getTableModel().fireTableDataChanged();
        this.meansItem.setSelected(!editIntercepts);
        this.interceptsItem.setSelected(editIntercepts);
    }

    private String getGraphicalEditorTitle() {
        return this.graphicalEditorTitle;
    }

    private String getTabularEditorTitle() {
        return this.tabularEditorTitle;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.graphicalEditor().setEditable(editable);
        this.tabularEditor().setEditable(editable);
        this.editable = editable;
    }
}

