/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesProperties;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.StructEMBayesSearchEditorWizard;
import edu.cmu.tetradapp.model.StructEmBayesSearchRunner;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class StructEmBayesSearchEditor
extends JPanel {
    private StructEMBayesSearchEditorWizard wizard;
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    private StructEmBayesSearchEditor(BayesIm bayesIm, DataSet dataSet) {
        if (bayesIm == null) {
            throw new NullPointerException("Bayes IM must not be null.");
        }
        JMenuBar menuBar = new JMenuBar();
        this.setLayout(new BorderLayout());
        this.add((Component)menuBar, "North");
        JMenu file = new JMenu("File");
        menuBar.add(file);
        this.setLayout(new BorderLayout());
        this.add((Component)menuBar, "North");
        Dag graph = bayesIm.getBayesPm().getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        this.wizard = new StructEMBayesSearchEditorWizard(bayesIm, workbench);
        this.wizard.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorValueChanged".equals(evt.getPropertyName())) {
                    StructEmBayesSearchEditor.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        workbenchScroll.setPreferredSize(new Dimension(400, 400));
        JScrollPane wizardScroll = new JScrollPane(this.getWizard());
        BayesProperties scorer = new BayesProperties(dataSet, graph);
        scorer.setGraph(graph);
        StringBuilder buf = new StringBuilder();
        buf.append("\nP-value = ").append(scorer.getLikelihoodRatioP());
        buf.append("\nDf = ").append(scorer.getPValueDf());
        buf.append("\nChi square = ").append(this.nf.format(scorer.getPValueChisq()));
        buf.append("\nBIC score = ").append(this.nf.format(scorer.getBic()));
        JTextArea modelParametersText = new JTextArea();
        modelParametersText.setText(buf.toString());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Model", wizardScroll);
        tabbedPane.add("Model Statistics", modelParametersText);
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, tabbedPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        this.add((Component)splitPane, "Center");
        this.setName("Bayes IM Editor");
        this.getWizard().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorClosing".equals(evt.getPropertyName())) {
                    StructEmBayesSearchEditor.this.firePropertyChange("editorClosing", null, StructEmBayesSearchEditor.this.getName());
                }
                if ("closeFrame".equals(evt.getPropertyName())) {
                    StructEmBayesSearchEditor.this.firePropertyChange("closeFrame", null, null);
                    StructEmBayesSearchEditor.this.firePropertyChange("editorClosing", true, true);
                }
            }
        });
    }

    public StructEmBayesSearchEditor(StructEmBayesSearchRunner semBayesEstWrapper) {
        this(semBayesEstWrapper.getEstimatedBayesIm(), semBayesEstWrapper.getDataSet());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private StructEMBayesSearchEditorWizard getWizard() {
        return this.wizard;
    }
}

