/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class SubsetDiscreteVariablesAction
extends AbstractAction {
    private DataEditor dataEditor;

    public SubsetDiscreteVariablesAction(DataEditor editor) {
        super("Copy Discrete Variables");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel selectedDataModel = this.getDataEditor().getSelectedDataModel();
        if (selectedDataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)selectedDataModel;
            for (int i = dataSet.getNumColumns(); i >= 0; --i) {
                if (!(dataSet.getVariable(i) instanceof DiscreteVariable)) continue;
                dataSet.removeColumn(i);
            }
            DataModelList list = new DataModelList();
            list.add(dataSet);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Requires a tabular data set.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

