/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataCellEditor;
import edu.cmu.tetradapp.editor.DataCellRenderer;
import edu.cmu.tetradapp.editor.DataModelContainer;
import edu.cmu.tetradapp.editor.DoNothingEditor;
import edu.cmu.tetradapp.editor.MultiplierEditor;
import edu.cmu.tetradapp.editor.MultiplierRenderer;
import edu.cmu.tetradapp.editor.RowNumberRenderer;
import edu.cmu.tetradapp.editor.TabularDataTable;
import edu.cmu.tetradapp.editor.TabularDataTransferHandler;
import edu.cmu.tetradapp.editor.VariableNameEditor;
import edu.cmu.tetradapp.editor.VariableNameRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TabularDataJTable
extends JTable
implements DataModelContainer,
PropertyChangeListener {
    Map<String, String> columnToTooltip;
    private int numLeadingCols = 2;
    private boolean editable = true;

    public TabularDataJTable(DataSet model, Map<String, String> columnToTooltip) {
        this(model);
        this.columnToTooltip = columnToTooltip;
    }

    public TabularDataJTable(DataSet model) {
        TabularDataTable dataModel = new TabularDataTable(model);
        dataModel.addPropertyChangeListener(this);
        this.setModel(dataModel);
        this.setAutoResizeMode(0);
        this.columnToTooltip = model.getColumnToTooltip() != null ? model.getColumnToTooltip() : new Hashtable<String, String>();
        int rowCount = this.dataModel.getRowCount();
        int max = 0;
        while (rowCount > 0) {
            rowCount /= 10;
            ++max;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = TabularDataJTable.this.rowAtPoint(e.getPoint());
                int col = TabularDataJTable.this.columnAtPoint(e.getPoint());
                if (row == 0) {
                    TabularDataJTable.this.setRowSelectionAllowed(false);
                    TabularDataJTable.this.setColumnSelectionAllowed(true);
                } else if (col == 0) {
                    TabularDataJTable.this.setRowSelectionAllowed(true);
                    TabularDataJTable.this.setColumnSelectionAllowed(false);
                } else {
                    TabularDataJTable.this.setRowSelectionAllowed(true);
                    TabularDataJTable.this.setColumnSelectionAllowed(true);
                }
            }
        });
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        this.getColumnModel().getColumn(0).setMaxWidth(9 * max);
        this.getColumnModel().getColumn(1).setMaxWidth(36);
        this.setRowHeight(metrics.getHeight() + 3);
        this.setRowSelectionAllowed(true);
        this.getColumnModel().setColumnSelectionAllowed(true);
        for (int i = 0; i < model.getNumColumns(); ++i) {
            if (!model.isSelected(model.getVariable(i))) continue;
            this.setRowSelectionAllowed(false);
            this.addColumnSelectionInterval(i + 2, i + 2);
        }
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                DataSet dataSet = TabularDataJTable.this.getDataSet();
                dataSet.clearSelection();
                if (!TabularDataJTable.this.getRowSelectionAllowed()) {
                    for (int i = 0; i < dataSet.getNumColumns(); ++i) {
                        if (!selectionModel.isSelectedIndex(i + 2)) continue;
                        dataSet.setSelected(dataSet.getVariable(i), true);
                    }
                }
            }
        });
        this.setTransferHandler(new TabularDataTransferHandler());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTable table = (JTable)e.getSource();
                TableCellEditor editor = table.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
            }
        });
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (c instanceof JComponent) {
            String tooltip;
            JComponent jc = (JComponent)c;
            Object o = this.getValueAt(rowIndex, vColIndex);
            if (o != null && (tooltip = this.columnToTooltip.get(o.toString())) != null) {
                jc.setToolTipText(tooltip);
            }
        }
        return c;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        try {
            super.setValueAt(aValue, row, column);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e.getMessage(), "Error", 2);
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (!this.editable) {
            return new DoNothingEditor();
        }
        if (row == 1) {
            return new VariableNameEditor();
        }
        if (column == 1 && row >= 2) {
            return new MultiplierEditor();
        }
        if (row > 1) {
            return new DataCellEditor();
        }
        return null;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return new RowNumberRenderer();
        }
        if (column == 1 && row >= 1) {
            return new MultiplierRenderer();
        }
        if (row == 0 || row == 1) {
            return new VariableNameRenderer();
        }
        return new DataCellRenderer(this, this.getNumLeadingCols());
    }

    public DataSet getDataSet() {
        TabularDataTable tableModelTabularData = (TabularDataTable)this.getModel();
        return tableModelTabularData.getDataSet();
    }

    public void setDataSet(DataSet data) {
        TabularDataTable tableModelTabularData = (TabularDataTable)this.getModel();
        tableModelTabularData.setDataSet(data);
    }

    @Override
    public DataModel getDataModel() {
        return this.getDataSet();
    }

    public void deleteSelected() {
        TabularDataTable model = (TabularDataTable)this.getModel();
        DataSet dataSet = model.getDataSet();
        if (!this.getRowSelectionAllowed()) {
            int[] selectedCols = this.getSelectedColumns();
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            int i = 0;
            while (i < selectedCols.length) {
                int n = i++;
                selectedCols[n] = selectedCols[n] - this.getNumLeadingCols();
            }
            dataSet.removeCols(selectedCols);
        } else if (!this.getColumnSelectionAllowed()) {
            int[] selectedRows = this.getSelectedRows();
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            int i = 0;
            while (i < selectedRows.length) {
                int n = i++;
                selectedRows[n] = selectedRows[n] - 2;
            }
            dataSet.removeRows(selectedRows);
        } else {
            throw new IllegalStateException("Only row deletion and column deltion supported.");
        }
        this.firePropertyChange("modelChanged", null, null);
        model.fireTableDataChanged();
    }

    public void clearSelected() {
        TabularDataTable model = (TabularDataTable)this.getModel();
        DataSet dataSet = model.getDataSet();
        if (!this.getRowSelectionAllowed()) {
            int[] selectedCols = this.getSelectedColumns();
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            for (int i = selectedCols.length - 1; i >= 0; --i) {
                int dataCol;
                if (selectedCols[i] < this.getNumLeadingCols() || (dataCol = selectedCols[i] - this.getNumLeadingCols()) >= dataSet.getNumColumns()) continue;
                Node variable = dataSet.getVariable(dataCol);
                Object missingValue = ((Variable)variable).getMissingValueMarker();
                for (int j = 0; j < dataSet.getNumRows(); ++j) {
                    dataSet.setObject(j, dataCol, missingValue);
                }
            }
        } else if (!this.getColumnSelectionAllowed()) {
            int[] selectedRows = this.getSelectedRows();
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            for (int i = this.getColumnCount() - 1; i >= 0; --i) {
                String colName;
                if (i < this.getNumLeadingCols() || (colName = (String)this.getValueAt(1, i)) == null) continue;
                int dataCol = i - this.getNumLeadingCols();
                Node variable = dataSet.getVariable(dataCol);
                Object missingValue = ((Variable)variable).getMissingValueMarker();
                for (int j = selectedRows.length - 1; j >= 0; --j) {
                    if (selectedRows[j] < 2 || selectedRows[j] > dataSet.getNumRows() + 1) continue;
                    dataSet.setObject(selectedRows[j] - 2, dataCol, missingValue);
                }
            }
        } else {
            int[] selectedRows = this.getSelectedRows();
            int[] selectedCols = this.getSelectedColumns();
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            for (int i = selectedCols.length - 1; i >= 0; --i) {
                String colName;
                int dataCol;
                if (selectedCols[i] < this.getNumLeadingCols() || (dataCol = selectedCols[i] - this.getNumLeadingCols()) >= dataSet.getNumColumns() || (colName = (String)this.getValueAt(1, selectedCols[i])) == null) continue;
                Node variable = dataSet.getVariable(dataCol);
                Object missingValue = ((Variable)variable).getMissingValueMarker();
                for (int j = selectedRows.length - 1; j >= 0; --j) {
                    if (selectedRows[j] < 2 || selectedRows[j] > dataSet.getNumRows() + 1) continue;
                    dataSet.setObject(selectedRows[j] - 2, dataCol, missingValue);
                }
            }
        }
        this.firePropertyChange("modelChanged", null, null);
        model.fireTableDataChanged();
    }

    private int getNumLeadingCols() {
        return this.numLeadingCols;
    }

    public boolean checkValueAt(String token, int col) {
        if (col < this.getNumLeadingCols()) {
            throw new IllegalArgumentException();
        }
        DataSet dataSet = this.getDataSet();
        int dataCol = col - this.getNumLeadingCols();
        if (dataCol < dataSet.getNumColumns()) {
            Node variable = dataSet.getVariable(dataCol);
            return ((Variable)variable).checkValue(token);
        }
        return true;
    }

    public void setShowCategoryNames(boolean selected) {
        TabularDataTable table = (TabularDataTable)this.getModel();
        table.setCategoryNamesShown(selected);
    }

    public boolean isShowCategoryNames() {
        TabularDataTable table = (TabularDataTable)this.getModel();
        return table.isCategoryNamesShown();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("modelChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("modelChanged", null, null);
        }
    }
}

