/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.RegexTokenizer;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.TabularDataJTable;
import edu.cmu.tetradapp.editor.TabularDataTable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;

public class TabularDataTransferHandler
extends TransferHandler {
    private int numLeadingCols = 2;
    private int numLeadingRows = 2;

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof TabularDataJTable) {
            int[] cols;
            int[] rows;
            TabularDataJTable tabularData = (TabularDataJTable)c;
            DataSet dataSet = tabularData.getDataSet();
            if (!tabularData.getRowSelectionAllowed() && !tabularData.getColumnSelectionAllowed()) {
                return null;
            }
            if (!tabularData.getRowSelectionAllowed()) {
                int rowCount = tabularData.getDataSet().getNumRows();
                rows = new int[rowCount + 1];
                for (int i = 0; i < rowCount + 1; ++i) {
                    rows[i] = i + this.getNumLeadingRows() - 1;
                }
            } else {
                int[] _rows = tabularData.getSelectedRows();
                if (Arrays.binarySearch(_rows, 1) == -1) {
                    rows = new int[_rows.length + 1];
                    rows[0] = 1;
                    System.arraycopy(_rows, 0, rows, 1, _rows.length);
                } else {
                    rows = _rows;
                }
            }
            if (!tabularData.getColumnSelectionAllowed()) {
                int colCount = tabularData.getDataSet().getNumColumns();
                cols = new int[colCount];
                for (int j = 0; j < colCount; ++j) {
                    cols[j] = j + this.getNumLeadingCols();
                }
            } else {
                cols = tabularData.getSelectedColumns();
            }
            if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (int displayRow : rows) {
                if (displayRow == 0) continue;
                for (int displayCol : cols) {
                    String name;
                    if (displayCol == 0 || (name = (String)tabularData.getValueAt(1, displayCol)) == null) continue;
                    if (displayRow == 1) {
                        String s = (String)tabularData.getValueAt(displayRow, displayCol);
                        if (s.trim().equals("")) {
                            s = "C" + (displayCol - 1);
                        }
                        String val = "";
                        if (s != null) {
                            val = s;
                        }
                        buf.append(val).append("\t");
                        continue;
                    }
                    int dataRow = displayRow - this.getNumLeadingRows();
                    int dataCol = displayCol - this.getNumLeadingCols();
                    if (dataCol < 0 || dataCol >= dataSet.getNumColumns()) continue;
                    if (dataRow < dataSet.getNumRows()) {
                        Object datumObj = dataSet.getObject(dataRow, dataCol);
                        String datumString = "";
                        if (datumObj != null) {
                            if (datumObj instanceof Number) {
                                datumString = datumObj.toString();
                            } else if (datumObj instanceof String) {
                                datumString = "\"" + datumObj.toString() + "\"";
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                        buf.append(datumString).append("\t");
                        continue;
                    }
                    buf.append("\t");
                }
                if (buf.length() - 1 <= 0) continue;
                buf.deleteCharAt(buf.length() - 1).append("\n");
            }
            if (buf.length() - 1 > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            return new StringSelection(buf.toString());
        }
        return null;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (c instanceof TabularDataJTable) {
            try {
                TabularDataJTable tabularData = (TabularDataJTable)c;
                String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                int startRow = tabularData.getSelectedRow();
                int startCol = tabularData.getSelectedColumn();
                if (startRow == 0) {
                    startRow = 1;
                }
                if (startCol < this.getNumLeadingCols()) {
                    startCol = this.getNumLeadingCols();
                }
                if (!this.checkRanges(s, startCol, tabularData)) {
                    return false;
                }
                boolean shouldAsk = false;
                boolean shiftDown = true;
                BufferedReader preReader = new BufferedReader(new CharArrayReader(s.toCharArray()));
                String preLine = preReader.readLine();
                StringTokenizer preTokenizer = new StringTokenizer(preLine, "\t");
                int numTokens = preTokenizer.countTokens();
                for (int col = startCol; col < startCol + numTokens; ++col) {
                    Object value = tabularData.getValueAt(startRow, col);
                    if (!"".equals(value) && null != value) {
                        shouldAsk = true;
                    }
                    if (startRow - this.getNumLeadingRows() < tabularData.getDataSet().getNumRows() && startCol - this.getNumLeadingCols() < tabularData.getDataSet().getNumColumns()) continue;
                    shouldAsk = false;
                    shiftDown = false;
                }
                if (shouldAsk) {
                    Object[] choices = new String[]{"Shift corresponding cells down to make room", "Replace corresponding cells"};
                    Object choice = JOptionPane.showInputDialog(JOptionUtils.centeringComp(), "How should the clipboard contents be pasted?", "Paste Contents", 1, null, choices, choices[0]);
                    if (choice == null) {
                        return false;
                    }
                    shiftDown = choice.equals(choices[0]);
                }
                this.doPaste(s, startRow, startCol, shiftDown, tabularData);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean checkRanges(String s, int startCol, TabularDataJTable tabularData) throws IOException {
        RegexTokenizer lines = new RegexTokenizer(s, Pattern.compile("\n"), '\"');
        lines.nextToken();
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            RegexTokenizer tokens = new RegexTokenizer(line, Pattern.compile("\t"), '\"');
            int col = startCol;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!tabularData.checkValueAt(token, col)) {
                    int dataCol = col - this.getNumLeadingCols();
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "<html>This paste cannot be completed, since the variable in <br>column " + dataCol + " cannot accept the value '" + token + "'." + "</html>");
                    return false;
                }
                ++col;
            }
        }
        return true;
    }

    private void doPaste(String s, int startRow, int startCol, boolean shiftDown, TabularDataJTable tabularData) throws IOException {
        int col;
        int i;
        startCol -= this.getNumLeadingCols();
        if ((startRow -= this.getNumLeadingRows()) < 0) {
            startRow = 0;
        }
        if (startCol < 0) {
            startCol = 0;
        }
        int pasteRows = 0;
        int pasteCols = -1;
        RegexTokenizer lines = new RegexTokenizer(s, Pattern.compile("\n"), '\"');
        lines.setQuoteSensitive(false);
        String line = lines.nextToken();
        RegexTokenizer _names = new RegexTokenizer(line, Pattern.compile("\t"), '\"');
        ArrayList<String> varNames = new ArrayList<String>();
        while (_names.hasMoreTokens()) {
            varNames.add(_names.nextToken());
        }
        System.out.println("varnames = " + varNames);
        while (lines.hasMoreTokens()) {
            line = lines.nextToken();
            if (line.length() == 0) continue;
            System.out.println("line = " + line);
            ++pasteRows;
            RegexTokenizer numbers = new RegexTokenizer(line, Pattern.compile("\t"), '\"');
            int _cols = 0;
            while (numbers.hasMoreTokens()) {
                numbers.nextToken();
                ++_cols;
            }
            if (pasteCols != -1) continue;
            pasteCols = _cols;
        }
        if (varNames.size() != pasteCols) {
            throw new IllegalArgumentException("Number of variable names must match the number of columns.");
        }
        DataSet dataSet = tabularData.getDataSet();
        int originalCols = dataSet.getNumColumns();
        dataSet.ensureColumns(startCol + pasteCols, varNames);
        if (shiftDown) {
            dataSet.ensureRows(startRow + 2 * pasteRows);
        } else {
            dataSet.ensureRows(startRow + pasteRows);
        }
        int newCols = dataSet.getNumColumns();
        for (int j = originalCols; j < newCols; ++j) {
            String _name;
            Node node = dataSet.getVariable(j);
            int index = j - (originalCols - 1) + (originalCols - 1 - startCol);
            if (index < 0) continue;
            String name = (String)varNames.get(index);
            if (dataSet.getVariable(name) == null) {
                node.setName(name);
                continue;
            }
            int i2 = 0;
            while (dataSet.getVariable(_name = name + "_" + ++i2) != null) {
            }
            node.setName(_name);
        }
        if (shiftDown) {
            for (i = pasteRows - 1; i >= 0; --i) {
                for (int j = 0; j < pasteCols; ++j) {
                    int oldRow = startRow + i;
                    int newRow = oldRow + pasteRows;
                    col = startCol + j;
                    int numRows = dataSet.getNumRows();
                    if (newRow >= numRows) continue;
                    Object value = tabularData.getValueAt(oldRow + this.getNumLeadingRows(), col + this.getNumLeadingCols());
                    tabularData.setValueAt(value, newRow + this.getNumLeadingRows(), col + this.getNumLeadingCols());
                }
            }
        }
        lines = new RegexTokenizer(s, Pattern.compile("\n"), '\"');
        lines.setQuoteSensitive(false);
        lines.nextToken();
        for (i = 0; i < pasteRows; ++i) {
            line = lines.nextToken();
            if (line.length() == 0) continue;
            RegexTokenizer tokens = new RegexTokenizer(line, Pattern.compile("\t"), '\"');
            for (int j = 0; j < pasteCols; ++j) {
                int row = startRow + i;
                col = startCol + j;
                String token = tokens.nextToken();
                tabularData.setValueAt(token, row + this.getNumLeadingRows(), col + this.getNumLeadingCols());
            }
        }
        TabularDataTable tableModel = (TabularDataTable)tabularData.getModel();
        tableModel.fireTableDataChanged();
    }

    @Override
    public void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2 && source instanceof TabularDataJTable) {
            TabularDataJTable tableTabular = (TabularDataJTable)source;
            tableTabular.deleteSelected();
        }
    }

    private int getNumLeadingCols() {
        return this.numLeadingCols;
    }

    private int getNumLeadingRows() {
        return this.numLeadingRows;
    }
}

