/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.LagIndTestParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;

class TimeSeriesIndTestParamsEditor
extends JComponent {
    private LagIndTestParams params = null;
    private DoubleTextField alphaField;
    private IntTextField numLagsField;

    public TimeSeriesIndTestParamsEditor(LagIndTestParams simulator) {
        this.params = simulator;
        this.alphaField = new DoubleTextField(this.getLagIndTestParams().getAlpha(), 5, NumberFormatUtil.getInstance().getNumberFormat());
        this.alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    TimeSeriesIndTestParamsEditor.this.getLagIndTestParams().setAlpha(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.numLagsField = new IntTextField(this.getLagIndTestParams().getNumLags(), 3);
        this.numLagsField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    TimeSeriesIndTestParamsEditor.this.getLagIndTestParams().setNumLags(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.buildGui();
    }

    private void buildGui() {
        this.setLayout(new BoxLayout(this, 1));
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Alpha:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(this.alphaField);
        this.add(b1);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Num Lags:"));
        b3.add(Box.createHorizontalGlue());
        b3.add(this.numLagsField);
        this.add(b3);
        this.add(Box.createVerticalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Num Times:"));
        b4.add(Box.createHorizontalGlue());
        int numTimePoints = this.getLagIndTestParams().getNumTimePoints();
        b4.add(new JLabel(Integer.toString(numTimePoints)));
        this.add(b4);
        this.add(Box.createVerticalGlue());
    }

    private LagIndTestParams getLagIndTestParams() {
        return this.params;
    }
}

