/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TreksAction
extends AbstractAction
implements ClipboardOwner {
    private GraphWorkbench workbench;

    public TreksAction(GraphWorkbench workbench) {
        super("Treks");
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Box b = Box.createVerticalBox();
        Graph graph = this.workbench.getGraph();
        JTextArea textArea = new JTextArea();
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setPreferredSize(new Dimension(600, 600));
        textArea.append("Treks:");
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            for (int j = 0; j < graph.getNodes().size(); ++j) {
                Node node2;
                Node node1 = graph.getNodes().get(i);
                List<List<Node>> treks = GraphUtils.treks(graph, node1, node2 = graph.getNodes().get(j));
                if (treks.isEmpty()) continue;
                textArea.append("\n\nBetween " + node1 + " and " + node2 + ":");
                for (int k = 0; k < treks.size(); ++k) {
                    List<Node> trek = treks.get(k);
                    textArea.append("\n    " + GraphUtils.pathString(graph, trek));
                }
            }
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(scroll);
        textArea.setCaretPosition(0);
        b.add(b2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(b);
        EditorWindow window = new EditorWindow(panel, "Treks", "Close", false, this.workbench);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

