/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.datamanip;

import edu.cmu.tetrad.data.ContinuousDiscretizationSpec;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.FinalizingParameterEditor;
import edu.cmu.tetradapp.editor.datamanip.ContinuousDiscretizationEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.datamanip.DiscretizationParams;
import edu.cmu.tetradapp.util.IntSpinner;
import edu.cmu.tetradapp.util.LayoutUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiscretizationParamsEditor
extends JPanel
implements FinalizingParameterEditor {
    private DataSet sourceDataSet;
    private Map<Node, ContinuousDiscretizationEditor> nodeEditors = new HashMap<Node, ContinuousDiscretizationEditor>();
    private JList discretizeVariableList;
    private DiscretizationParams params;
    private JTabbedPane editorPane;

    @Override
    public void setup() {
        System.out.println("setup");
        List<Node> variables = this.sourceDataSet.getVariables();
        Set<Node> previousNodes = this.params.getSpecs().keySet();
        LinkedList<Node> allVariables = new LinkedList<Node>();
        LinkedList<Node> discretizeVars = new LinkedList<Node>();
        for (Node node : variables) {
            if (node instanceof ContinuousVariable && previousNodes.contains(node)) {
                discretizeVars.add(node);
            }
            if (!(node instanceof ContinuousVariable)) continue;
            allVariables.add(node);
        }
        this.discretizeVariableList = new JList(new VariableListModel(allVariables));
        this.discretizeVariableList.setCellRenderer(new VariableBoxRenderer());
        this.discretizeVariableList.getSelectionModel().setSelectionMode(1);
        this.discretizeVariableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = (JList)e.getSource();
                List selected = DiscretizationParamsEditor.getSelected(list);
                for (Node node : selected) {
                    DiscretizationParamsEditor.this.nodeEditors.put(node, DiscretizationParamsEditor.this.createEditor(node));
                }
                if (selected.size() == 1) {
                    DiscretizationParamsEditor.this.editorPane.removeAll();
                    Node node = (Node)selected.get(0);
                    DiscretizationParamsEditor.this.editorPane.add(node.getName(), (Component)DiscretizationParamsEditor.this.nodeEditors.get(node));
                } else if (1 < selected.size()) {
                    DiscretizationParamsEditor.this.editorPane.removeAll();
                    Node first = (Node)selected.get(0);
                    Node last = (Node)selected.get(selected.size() - 1);
                    String label = first.getName() + " - " + last.getName();
                    DiscretizationParamsEditor.this.editorPane.add(label, new VariableSelectionEditor(selected));
                }
            }
        });
        for (Node node : discretizeVars) {
            ContinuousVariable continuousVariable = (ContinuousVariable)node;
            ContinuousDiscretizationEditor editor = new ContinuousDiscretizationEditor(this.sourceDataSet, continuousVariable, 2, ContinuousDiscretizationEditor.Method.EVENLY_DIVIDED_INTERNVALS);
            editor.setDiscretizationSpec(this.params.getSpecs().get(node));
            this.nodeEditors.put(node, editor);
        }
        this.editorPane = new JTabbedPane();
        JScrollPane editorScrollPane = new JScrollPane(this.editorPane);
        editorScrollPane.setPreferredSize(new Dimension(400, 350));
        JCheckBox copyUnselectedCheckBox = new JCheckBox("Copy unselected columns into new data set");
        copyUnselectedCheckBox.setHorizontalTextPosition(2);
        copyUnselectedCheckBox.setSelected(Preferences.userRoot().getBoolean("copyUnselectedColumns", false));
        copyUnselectedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                Preferences.userRoot().putBoolean("copyUnselectedColumns", checkBox.isSelected());
            }
        });
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        Box selectionBox = Box.createVerticalBox();
        selectionBox.add(Box.createVerticalStrut(5));
        selectionBox.add(Box.createVerticalGlue());
        Box discreteSelectionBox = Box.createVerticalBox();
        JLabel discreteLabel = new JLabel("Variables to Discretize:");
        JScrollPane discreteListPane = new JScrollPane(this.discretizeVariableList);
        int width2 = Math.max(100, discreteLabel.getPreferredSize().width);
        LayoutUtils.setAllSizes(discreteListPane, new Dimension(width2, 350 - discreteLabel.getPreferredSize().height));
        discreteSelectionBox.add(Box.createVerticalStrut(5));
        discreteSelectionBox.add(LayoutUtils.leftAlignJLabel(discreteLabel));
        discreteSelectionBox.add(discreteListPane);
        discreteSelectionBox.add(Box.createVerticalGlue());
        hBox.add(selectionBox);
        hBox.add(Box.createHorizontalStrut(4));
        hBox.add(discreteSelectionBox);
        hBox.add(Box.createHorizontalStrut(8));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(editorScrollPane);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createHorizontalGlue());
        b4.add(copyUnselectedCheckBox);
        vBox.add(b4);
        vBox.add(Box.createVerticalStrut(10));
        hBox.add(vBox);
        hBox.add(Box.createHorizontalStrut(5));
        this.add((Component)hBox, "Center");
    }

    @Override
    public boolean finalizeEdit() {
        if (this.nodeEditors.isEmpty()) {
            return false;
        }
        HashMap<Node, ContinuousDiscretizationSpec> map = new HashMap<Node, ContinuousDiscretizationSpec>();
        for (Node node : this.nodeEditors.keySet()) {
            ContinuousDiscretizationEditor editor = this.nodeEditors.get(node);
            map.put(node, editor.getDiscretizationSpec());
        }
        this.params.setSpecs(map);
        return true;
    }

    @Override
    public void setParams(Params params) {
        this.params = (DiscretizationParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null || parentModels.length == 0) {
            throw new IllegalArgumentException("There must be parent model");
        }
        DataWrapper data = null;
        for (Object parent : parentModels) {
            if (!(parent instanceof DataWrapper)) continue;
            data = (DataWrapper)parent;
        }
        if (data == null) {
            throw new IllegalArgumentException("Should have have a data wrapper as a parent");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The dataset must be a rectangular dataset");
        }
        this.sourceDataSet = (DataSet)model;
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private Component getViewingComponent() {
        int tabs = this.editorPane.getTabCount();
        if (0 < tabs) {
            return this.editorPane.getComponentAt(0);
        }
        return null;
    }

    private static List<Node> getSelected(JList list) {
        Object[] selected = list.getSelectedValues();
        LinkedList<Node> nodes = new LinkedList<Node>();
        if (selected != null) {
            for (Object o : selected) {
                nodes.add((Node)o);
            }
        }
        return nodes;
    }

    private ContinuousDiscretizationEditor createEditor(Node node) {
        return new ContinuousDiscretizationEditor(this.sourceDataSet, (ContinuousVariable)node, 3, ContinuousDiscretizationEditor.Method.EVENLY_DIVIDED_INTERNVALS);
    }

    private boolean globalChangeVerification() {
        if (!Preferences.userRoot().getBoolean("ignoreGlobalDiscretizationWarning", false)) {
            Box box = Box.createVerticalBox();
            String message = "<html>This action will change the number of categories for all selected variales<br>and override any previous work. Are you sure you want continue?</html>";
            box.add(new JLabel(message));
            box.add(Box.createVerticalStrut(5));
            JCheckBox checkBox = new JCheckBox("Don't show this again");
            checkBox.setHorizontalTextPosition(2);
            checkBox.setHorizontalAlignment(4);
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox box = (JCheckBox)e.getSource();
                    Preferences.userRoot().putBoolean("ignoreGlobalDiscretizationWarning", box.isSelected());
                }
            });
            box.add(checkBox);
            box.add(Box.createVerticalStrut(5));
            int option = JOptionPane.showConfirmDialog(this, box, "Discretization Warning", 0);
            return 0 == option;
        }
        return true;
    }

    private void changeNumberOfCategories(int numOfCats, List<Node> nodes) {
        for (Node node : nodes) {
            ContinuousDiscretizationEditor editor = this.nodeEditors.get(node);
            if (editor == null) continue;
            editor.setNumCategories(numOfCats);
        }
    }

    private void changeMethod(List<Node> nodes, ContinuousDiscretizationEditor.Method method) {
        for (Node node : nodes) {
            ContinuousDiscretizationEditor editor = this.nodeEditors.get(node);
            if (editor == null) continue;
            editor.setMethod(method);
        }
    }

    private ContinuousDiscretizationEditor.Method getCommonMethod(List<Node> nodes) {
        ContinuousDiscretizationEditor.Method method = null;
        for (Node node : nodes) {
            ContinuousDiscretizationEditor editor = this.nodeEditors.get(node);
            if (method != null && method != editor.getMethod()) {
                return null;
            }
            method = editor.getMethod();
        }
        return method;
    }

    private int getDefaultCategoryNum(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return 3;
        }
        ContinuousDiscretizationEditor editor = this.nodeEditors.get(nodes.get(0));
        int value = editor.getNumCategories();
        for (int i = 1; i < nodes.size(); ++i) {
            editor = this.nodeEditors.get(nodes.get(i));
            if (value == editor.getNumCategories()) continue;
            return 3;
        }
        return value;
    }

    private static class VariableBoxRenderer
    extends DefaultListCellRenderer {
        private VariableBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = (Node)value;
            if (node == null) {
                this.setText("");
            } else {
                this.setText(node.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class VariableListModel
    extends AbstractListModel {
        private Vector<Node> variables;

        public VariableListModel(List<Node> variables) {
            this.variables = new Vector<Node>(variables);
        }

        @Override
        public int getSize() {
            return this.variables.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.variables.get(index);
        }

        public void removeAll(List<Node> nodes) {
            int size = this.getSize();
            this.variables.removeAll(nodes);
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        public void add(Node node) {
            if (!this.variables.contains(node)) {
                this.variables.add(node);
                this.fireIntervalAdded(this, this.getSize() - 2, this.getSize() - 1);
            }
        }

        public void addAll(List<Node> nodes) {
            for (Node node : nodes) {
                if (this.variables.contains(node)) continue;
                this.variables.add(node);
            }
            this.fireIntervalAdded(this, this.getSize() - nodes.size(), nodes.size() - 1);
        }
    }

    private class VariableSelectionEditor
    extends JPanel {
        private List<Node> nodes;

        public VariableSelectionEditor(List<Node> vars) {
            this.setLayout(new BorderLayout());
            this.nodes = vars;
            IntSpinner spinner = new IntSpinner(DiscretizationParamsEditor.this.getDefaultCategoryNum(vars), 1, 3);
            ContinuousDiscretizationEditor.Method method = DiscretizationParamsEditor.this.getCommonMethod(vars);
            spinner.setMin(2);
            spinner.setFilter(new IntSpinner.Filter(){

                @Override
                public int filter(int oldValue, int newValue) {
                    if (DiscretizationParamsEditor.this.globalChangeVerification()) {
                        DiscretizationParamsEditor.this.changeNumberOfCategories(newValue, VariableSelectionEditor.this.nodes);
                        return newValue;
                    }
                    return oldValue;
                }
            });
            Box vBox = Box.createVerticalBox();
            vBox.add(new JLabel("Discretization Method: "));
            JRadioButton equalInterval = new JRadioButton("Evenly Distributed Intervals", method == ContinuousDiscretizationEditor.Method.EVENLY_DIVIDED_INTERNVALS);
            JRadioButton equalBuckets = new JRadioButton("Evenly Distributed Values", method == ContinuousDiscretizationEditor.Method.EQUAL_SIZE_BUCKETS);
            equalInterval.setHorizontalTextPosition(4);
            equalBuckets.setHorizontalTextPosition(4);
            equalInterval.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiscretizationParamsEditor.this.changeMethod(VariableSelectionEditor.this.nodes, ContinuousDiscretizationEditor.Method.EVENLY_DIVIDED_INTERNVALS);
                }
            });
            equalBuckets.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiscretizationParamsEditor.this.changeMethod(VariableSelectionEditor.this.nodes, ContinuousDiscretizationEditor.Method.EQUAL_SIZE_BUCKETS);
                }
            });
            ButtonGroup group = new ButtonGroup();
            group.add(equalInterval);
            group.add(equalBuckets);
            vBox.add(equalInterval);
            vBox.add(equalBuckets);
            Box buttons = Box.createHorizontalBox();
            buttons.add(vBox);
            buttons.add(Box.createHorizontalGlue());
            buttons.setBorder(new EmptyBorder(15, 5, 5, 5));
            Box cats = Box.createHorizontalBox();
            cats.add(new JLabel(" Change number of categories: "));
            cats.add(spinner);
            cats.add(Box.createHorizontalGlue());
            cats.setBorder(new EmptyBorder(5, 5, 5, 5));
            Box vBox1 = Box.createVerticalBox();
            vBox1.add(buttons);
            vBox1.add(cats);
            vBox1.add(Box.createVerticalGlue());
            this.add((Component)vBox1, "North");
        }

        public boolean contains(List<Node> nodes) {
            for (Node node : nodes) {
                if (!this.nodes.contains(node)) continue;
                return true;
            }
            return false;
        }
    }
}

