/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor.datamanip;

import edu.cmu.tetrad.data.ContinuousDiscretizationSpec;
import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

final class RangeEditor
extends JComponent {
    private Variable variable;
    private final double[] breakpoints;
    private final List<String> categories;
    private StringTextField[] categoryFields;
    private DoubleTextField[] leftRangeFields;
    private DoubleTextField[] rightRangeFields;
    private LinkedList<JTextField> focusTraveralOrder = new LinkedList();
    private Map<Object, Integer> labels = new HashMap<Object, Integer>();
    private boolean editableRange;

    public RangeEditor(Variable variable, ContinuousDiscretizationSpec spec, boolean editable) {
        this.variable = variable;
        this.breakpoints = spec.getBreakpoints();
        this.categories = spec.getCategories();
        this.editableRange = editable;
        this.buildEditor();
    }

    public void setEditableRange(boolean editableRange) {
        this.editableRange = editableRange;
        this.removeAll();
        this.buildEditor();
    }

    public ContinuousDiscretizationSpec getDiscretizationSpec() {
        return new ContinuousDiscretizationSpec(this.breakpoints, this.categories);
    }

    private void buildEditor() {
        Box rangeEditor = Box.createVerticalBox();
        this.createCategoryFields();
        this.createRangeFields();
        for (int i = 0; i < this.categories.size(); ++i) {
            Box row = Box.createHorizontalBox();
            row.add(Box.createRigidArea(new Dimension(10, 0)));
            row.add(new JLabel(i + 1 + ". "));
            row.add(this.categoryFields[i]);
            row.add(new BigLabel(" = [ "));
            row.add(this.leftRangeFields[i]);
            row.add(new BigLabel(", "));
            row.add(this.rightRangeFields[i]);
            if (i < this.categories.size() - 1) {
                row.add(new BigLabel(" )"));
            } else {
                row.add(new BigLabel(" ]"));
            }
            row.add(Box.createHorizontalGlue());
            rangeEditor.add(row);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)rangeEditor, "Center");
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.setFocusCycleRoot(true);
    }

    private void createCategoryFields() {
        this.categoryFields = new StringTextField[this.getNumCategories()];
        for (int i = 0; i < this.getNumCategories(); ++i) {
            String category = this.categories.get(i);
            this.categoryFields[i] = new StringTextField(category, 6);
            final StringTextField _field = this.categoryFields[i];
            this.categoryFields[i].setFilter(new StringTextField.Filter(){

                @Override
                public String filter(String value, String oldValue) {
                    if (RangeEditor.this.labels.get(_field) != null) {
                        int index = (Integer)RangeEditor.this.labels.get(_field);
                        if (value == null) {
                            value = (String)RangeEditor.this.categories.get(index);
                        }
                        for (int i = 0; i < RangeEditor.this.categories.size(); ++i) {
                            if (i == index || !((String)RangeEditor.this.categories.get(i)).equals(value)) continue;
                            value = (String)RangeEditor.this.categories.get(index);
                        }
                        RangeEditor.this.categories.set(index, value);
                    }
                    return value;
                }
            });
            this.labels.put(this.categoryFields[i], i);
            this.focusTraveralOrder.add(this.categoryFields[i]);
        }
    }

    private void createRangeFields() {
        this.leftRangeFields = new DoubleTextField[this.getNumCategories()];
        this.rightRangeFields = new DoubleTextField[this.getNumCategories()];
        int maxCategory = this.getNumCategories() - 1;
        this.leftRangeFields[0] = new DoubleTextField(Double.NEGATIVE_INFINITY, 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.leftRangeFields[0].setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                return oldValue;
            }
        });
        this.rightRangeFields[maxCategory] = new DoubleTextField(Double.POSITIVE_INFINITY, 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.rightRangeFields[maxCategory].setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                return oldValue;
            }
        });
        this.leftRangeFields[0].setEditable(false);
        this.rightRangeFields[maxCategory].setEditable(false);
        this.leftRangeFields[0].setHorizontalAlignment(0);
        this.rightRangeFields[maxCategory].setHorizontalAlignment(0);
        for (int i = 0; i < this.getNumCategories() - 1; ++i) {
            this.rightRangeFields[i] = new DoubleTextField(this.breakpoints[i], 6, NumberFormatUtil.getInstance().getNumberFormat());
            this.rightRangeFields[i].setEditable(false);
            this.labels.put(this.rightRangeFields[i], i);
            this.leftRangeFields[i + 1] = new DoubleTextField(this.breakpoints[i], 6, NumberFormatUtil.getInstance().getNumberFormat());
            this.leftRangeFields[i + 1].setEditable(this.editableRange);
            this.labels.put(this.leftRangeFields[i + 1], i + 1);
            final Integer label = this.labels.get(this.leftRangeFields[i + 1]);
            this.leftRangeFields[i + 1].setFilter(new DoubleTextField.Filter(){

                @Override
                public double filter(double value, double oldValue) {
                    if (label == null) {
                        return oldValue;
                    }
                    int index = (Integer)label;
                    if (index - 1 > 0 && !(RangeEditor.this.breakpoints[index - 2] < value)) {
                        value = RangeEditor.this.breakpoints[index - 1];
                    }
                    if (index - 1 < RangeEditor.this.breakpoints.length - 1 && !(value < RangeEditor.this.breakpoints[index])) {
                        value = RangeEditor.this.breakpoints[index - 1];
                    }
                    ((RangeEditor)RangeEditor.this).breakpoints[index - 1] = value;
                    RangeEditor.this.getRightRangeFields()[index - 1].setValue(value);
                    return value;
                }
            });
            this.labels.put(this.leftRangeFields[i + 1], i + 1);
            this.focusTraveralOrder.add(this.leftRangeFields[i + 1]);
        }
    }

    private DoubleTextField[] getRightRangeFields() {
        return this.rightRangeFields;
    }

    public Variable getVariable() {
        return this.variable;
    }

    private int getNumCategories() {
        return this.categories.size();
    }

    private class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int index = RangeEditor.this.focusTraveralOrder.indexOf(aComponent);
            int size = RangeEditor.this.focusTraveralOrder.size();
            if (index != -1) {
                return (Component)RangeEditor.this.focusTraveralOrder.get((index + 1) % size);
            }
            return this.getFirstComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int index = RangeEditor.this.focusTraveralOrder.indexOf(aComponent);
            int size = RangeEditor.this.focusTraveralOrder.size();
            if (index != -1) {
                return (Component)RangeEditor.this.focusTraveralOrder.get((index - 1) % size);
            }
            return this.getFirstComponent(focusCycleRoot);
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return (Component)RangeEditor.this.focusTraveralOrder.getFirst();
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return (Component)RangeEditor.this.focusTraveralOrder.getLast();
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.getFirstComponent(focusCycleRoot);
        }
    }

    private static final class BigLabel
    extends JLabel {
        private static Font FONT = new Font("Dialog", 1, 20);

        public BigLabel(String text) {
            super(text);
            this.setFont(FONT);
        }
    }
}

