/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.util.dist.Normal;
import edu.cmu.tetradapp.model.BooleanGlassGeneIm;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ErrorsTable
extends AbstractTableModel {
    private BooleanGlassGeneIm im = null;
    private List factors = null;

    public ErrorsTable(BooleanGlassGeneIm im) {
        this.im = im;
        this.factors = im.getFactors();
    }

    @Override
    public int getRowCount() {
        return this.factors.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Factor";
        }
        if (column == 1) {
            return "St. Dev.";
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0 && row < this.factors.size()) {
            return this.factors.get(row);
        }
        if (column == 1 && row < this.factors.size()) {
            Normal dist = (Normal)this.im.getErrorDistribution(row);
            return dist.getParameter(1);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 1 && row < this.factors.size()) {
            double d = new Double((String)value);
            if (d <= 0.0) {
                return;
            }
            Normal dist = (Normal)this.im.getErrorDistribution(row);
            dist.setParameter(1, d);
        }
    }
}

