/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.MeasurementSimulatorParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MeasurementModelPropertyEditor
extends JPanel {
    private MeasurementSimulatorParams simulator = null;
    private DoubleTextField dishDishVariabilityField;
    private IntTextField numSamplesPerDishField;
    private DoubleTextField sampleSampleVariabilityField;
    private DoubleTextField chipChipVariabilityField;
    private DoubleTextField pixelDigitalizationField;

    public MeasurementModelPropertyEditor(MeasurementSimulatorParams simulator) {
        this.simulator = simulator;
        this.dishDishVariabilityField = new DoubleTextField(this.getSimulator().getDishDishVariability(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.dishDishVariabilityField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementModelPropertyEditor.this.getSimulator().setDishDishVariability(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.numSamplesPerDishField = new IntTextField(this.getSimulator().getNumSamplesPerDish(), 4);
        this.numSamplesPerDishField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MeasurementModelPropertyEditor.this.getSimulator().setNumSamplesPerDish(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.sampleSampleVariabilityField = new DoubleTextField(this.getSimulator().getSampleSampleVariability(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.sampleSampleVariabilityField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementModelPropertyEditor.this.getSimulator().setSampleSampleVariability(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.chipChipVariabilityField = new DoubleTextField(this.getSimulator().getChipChipVariability(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.chipChipVariabilityField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementModelPropertyEditor.this.getSimulator().setChipChipVariability(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.pixelDigitalizationField = new DoubleTextField(this.getSimulator().getPixelDigitalization(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.pixelDigitalizationField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementModelPropertyEditor.this.getSimulator().setPixelDigitalization(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.buildGui();
    }

    private final void buildGui() {
        this.setLayout(new BorderLayout());
        Box b1 = Box.createHorizontalBox();
        Box b2 = Box.createHorizontalBox();
        Box b3 = Box.createHorizontalBox();
        Box b4 = Box.createHorizontalBox();
        Box b5 = Box.createHorizontalBox();
        Box b6 = Box.createVerticalBox();
        b1.add(new JLabel("Dish to dish variability (in Percent): "));
        b1.add(Box.createHorizontalGlue());
        b1.add(this.dishDishVariabilityField);
        b2.add(new JLabel("Number of samples per dish: "));
        b2.add(Box.createHorizontalGlue());
        b2.add(this.numSamplesPerDishField);
        b3.add(new JLabel("Sample to sample variability: "));
        b3.add(Box.createHorizontalGlue());
        b3.add(this.sampleSampleVariabilityField);
        b4.add(new JLabel("Chip to chip variability: "));
        b4.add(Box.createHorizontalGlue());
        b4.add(this.chipChipVariabilityField);
        b5.add(new JLabel("Pixel digitalization variability: "));
        b5.add(Box.createHorizontalGlue());
        b5.add(this.pixelDigitalizationField);
        b6.add(b1);
        b6.add(b2);
        b6.add(b3);
        b6.add(b4);
        b6.add(b5);
        b6.add(Box.createHorizontalGlue());
        this.add((Component)b6, "Center");
    }

    protected synchronized MeasurementSimulatorParams getSimulator() {
        return this.simulator;
    }
}

