/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.MeasurementSimulatorParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class MeasurementSimulatorPropertyEditor
extends JPanel
implements ParameterEditor {
    private MeasurementSimulatorParams simulator = null;
    private DoubleTextField dishDishVariabilityField;
    private DoubleTextField sampleSampleVariabilityField;
    private DoubleTextField chipChipVariabilityField;
    private DoubleTextField pixelDigitalizationField;
    private JCheckBox synchronizedCheckBox;
    private IntTextField numDishesField;
    private IntTextField numCellsPerDishField;
    private IntTextField numSamplesPerDishField;
    private IntTextField stepsGeneratedField;
    private IntTextField firstStepStoredField;
    private IntTextField intervalField;
    private JCheckBox rawDataSavedCheckBox;
    private JCheckBox antilogCalculatedCheckBox;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.simulator = (MeasurementSimulatorParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        this.dishDishVariabilityField = new DoubleTextField(this.getSimulator().getDishDishVariability(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.dishDishVariabilityField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setDishDishVariability(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.sampleSampleVariabilityField = new DoubleTextField(this.getSimulator().getSampleSampleVariability(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.sampleSampleVariabilityField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setSampleSampleVariability(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.chipChipVariabilityField = new DoubleTextField(this.getSimulator().getChipChipVariability(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.chipChipVariabilityField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setChipChipVariability(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.pixelDigitalizationField = new DoubleTextField(this.getSimulator().getPixelDigitalization(), 6, NumberFormatUtil.getInstance().getNumberFormat());
        this.pixelDigitalizationField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setPixelDigitalization(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.numDishesField = new IntTextField(this.getSimulator().getNumDishes(), 6);
        this.numDishesField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setNumDishes(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.numCellsPerDishField = new IntTextField(this.getSimulator().getNumCellsPerDish(), 6);
        this.numCellsPerDishField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setNumCellsPerDish(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.numSamplesPerDishField = new IntTextField(this.getSimulator().getNumSamplesPerDish(), 6);
        this.numSamplesPerDishField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setNumSamplesPerDish(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.stepsGeneratedField = new IntTextField(this.getSimulator().getStepsGenerated(), 6);
        this.stepsGeneratedField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setStepsGenerated(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.firstStepStoredField = new IntTextField(this.getSimulator().getFirstStepStored(), 6);
        this.firstStepStoredField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setFirstStepStored(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.intervalField = new IntTextField(this.getSimulator().getInterval(), 3);
        this.intervalField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    MeasurementSimulatorPropertyEditor.this.getSimulator().setInterval(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        this.synchronizedCheckBox = new JCheckBox("Synchronize cell initialization?", this.getSimulator().isInitSync());
        this.synchronizedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                MeasurementSimulatorPropertyEditor.this.getSimulator().setInitSync(checkBox.isSelected());
            }
        });
        this.rawDataSavedCheckBox = new JCheckBox("Save raw data?", this.getSimulator().isRawDataSaved());
        this.rawDataSavedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                MeasurementSimulatorPropertyEditor.this.getSimulator().setRawDataSaved(checkBox.isSelected());
            }
        });
        this.antilogCalculatedCheckBox = new JCheckBox("Calculate antilogs of data?", this.getSimulator().isAntilogCalculated());
        this.antilogCalculatedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                MeasurementSimulatorPropertyEditor.this.getSimulator().setAntilogCalculated(checkBox.isSelected());
            }
        });
        this.buildGui();
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private void buildGui() {
        this.setLayout(new BorderLayout());
        Box b1 = Box.createHorizontalBox();
        Box b2 = Box.createHorizontalBox();
        Box b3 = Box.createHorizontalBox();
        Box b4 = Box.createHorizontalBox();
        Box b5 = Box.createVerticalBox();
        b1.add(new JLabel("Dish to dish variability (in Percent): "));
        b1.add(Box.createHorizontalGlue());
        b1.add(this.dishDishVariabilityField);
        b2.add(new JLabel("Sample to sample variability: "));
        b2.add(Box.createHorizontalGlue());
        b2.add(this.sampleSampleVariabilityField);
        b3.add(new JLabel("Chip to chip variability: "));
        b3.add(Box.createHorizontalGlue());
        b3.add(this.chipChipVariabilityField);
        b4.add(new JLabel("Pixel digitalization variability: "));
        b4.add(Box.createHorizontalGlue());
        b4.add(this.pixelDigitalizationField);
        b5.add(b1);
        b5.add(b2);
        b5.add(b3);
        b5.add(b4);
        b5.add(Box.createHorizontalGlue());
        this.setLayout(new BorderLayout());
        Box bb1 = Box.createHorizontalBox();
        Box bb2 = Box.createHorizontalBox();
        Box bb3 = Box.createHorizontalBox();
        Box bb4 = Box.createHorizontalBox();
        Box bb5 = Box.createHorizontalBox();
        Box bb6 = Box.createHorizontalBox();
        Box bb7 = Box.createHorizontalBox();
        Box bb8 = Box.createHorizontalBox();
        Box bb9 = Box.createHorizontalBox();
        Box bb10 = Box.createVerticalBox();
        bb1.add(new JLabel("Number of dishes: "));
        bb1.add(Box.createHorizontalGlue());
        bb1.add(this.numDishesField);
        bb2.add(new JLabel("Number of cells per dish: "));
        bb2.add(Box.createHorizontalGlue());
        bb2.add(this.numCellsPerDishField);
        bb3.add(new JLabel("Number of samples per dish: "));
        bb3.add(Box.createHorizontalGlue());
        bb3.add(this.numSamplesPerDishField);
        bb4.add(new JLabel("Steps generated: "));
        bb4.add(Box.createHorizontalGlue());
        bb4.add(this.stepsGeneratedField);
        bb5.add(new JLabel("First step stored: "));
        bb5.add(Box.createHorizontalGlue());
        bb5.add(this.firstStepStoredField);
        bb6.add(new JLabel("Keep every "));
        bb6.add(this.intervalField);
        bb6.add(new JLabel(" steps."));
        bb7.add(this.synchronizedCheckBox);
        bb8.add(this.rawDataSavedCheckBox);
        bb9.add(this.antilogCalculatedCheckBox);
        bb10.add(bb1);
        bb10.add(bb2);
        bb10.add(bb3);
        bb10.add(bb4);
        bb10.add(bb5);
        bb10.add(bb6);
        bb10.add(bb7);
        bb10.add(bb8);
        bb10.add(bb9);
        bb10.add(Box.createHorizontalGlue());
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.add((Component)b5, "Center");
        top.setBorder(new TitledBorder("Measurement Model"));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BorderLayout());
        bottom.add((Component)bb10, "Center");
        bottom.setBorder(new TitledBorder("Simulation Parameters"));
        Box both = Box.createVerticalBox();
        both.add(top);
        both.add(bottom);
        this.add((Component)both, "Center");
    }

    protected synchronized MeasurementSimulatorParams getSimulator() {
        String ret = this.simulator == null ? "null" : this.simulator.toString();
        return this.simulator;
    }
}

