/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetradapp.gene.editor.MultiGraphNode;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.PointPair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

public class MultiGraphEdge
extends DisplayEdge {
    protected int visibility;
    protected boolean isSelfEdge = false;
    private static final float ARC_HEIGHT = 120.0f;
    private static final int SELECTION_FAT = 5;
    public static final Stroke UNANCHORED_STROKE = new BasicStroke(1.0f);
    public static final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    protected Point controlPoint;
    private Polygon clickRegion = null;

    public MultiGraphEdge(DisplayNode node1, DisplayNode node2) {
        super(node1, node2, 0);
        this.setVisibility(255);
        if (node1 instanceof MultiGraphNode && node2 instanceof MultiGraphNode) {
            MultiGraphNode mNode1 = (MultiGraphNode)node1;
            MultiGraphNode mNode2 = (MultiGraphNode)node2;
            String name1 = mNode1.getFactorGroup().getName();
            int lag = mNode2.getTimestep() - mNode1.getTimestep();
            boolean bl = this.isSelfEdge = name1.equals(mNode2.getFactorGroup().getName()) && lag > 1;
            if (this.isSelfEdge) {
                this.resetBounds();
            }
        }
    }

    public void setVisibility(int visibility) {
        if (visibility < 0 || visibility > 255) {
            throw new IllegalArgumentException("visibility must be 0-255");
        }
        this.visibility = visibility;
    }

    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke origStroke = g2.getStroke();
        PointPair pp = null;
        switch (this.getMode()) {
            case 0: {
                g.setColor(this.getLineColor());
                g2.setStroke(UNANCHORED_STROKE);
                pp = this.calculateEdge(this.getNode1(), this.getRelativeMouseTrackPoint());
                break;
            }
            case 1: {
                Color c = new Color(this.getLineColor().getRed(), this.getLineColor().getGreen(), this.getLineColor().getBlue(), this.getVisibility());
                g.setColor(c);
                g2.setStroke(NORMAL_STROKE);
                pp = this.calculateEdge(this.getNode1(), this.getNode2());
                break;
            }
            case 2: {
                g.setColor(this.getSelectedColor());
                g2.setStroke(NORMAL_STROKE);
                pp = this.calculateEdge(this.getNode1(), this.getNode2());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (pp != null) {
            Point loc = this.getLocation();
            pp.getFrom().translate(-loc.x, -loc.y);
            pp.getTo().translate(-loc.x, -loc.y);
            this.setClickRegion(null);
            if (this.isSelfEdge) {
                Point tempCPoint = new Point(this.controlPoint);
                QuadCurve2D.Float arc = new QuadCurve2D.Float(pp.getFrom().x, pp.getFrom().y, tempCPoint.x, tempCPoint.y, pp.getTo().x, pp.getTo().y);
                g2.draw(arc);
                PointPair pp2 = new PointPair(tempCPoint, pp.getTo());
                this.drawEndpoints(pp2, g);
            } else {
                g.drawLine(pp.getFrom().x, pp.getFrom().y, pp.getTo().x, pp.getTo().y);
                this.drawEndpoints(pp, g);
            }
            g2.setStroke(origStroke);
            this.setConnectedPoints(pp);
            this.firePropertyChange("newPointPair", null, pp);
        }
    }

    @Override
    protected void resetBounds() {
        if (this.getMode() == 0 || !this.isSelfEdge) {
            super.resetBounds();
        } else {
            PointPair endP = this.calculateEdge(this.getNode1(), this.getNode2());
            Rectangle bounds1 = this.getNode1().getBounds();
            Rectangle bounds2 = this.getNode2().getBounds();
            Rectangle baseBounds = bounds1.union(bounds2);
            if (endP == null) {
                this.setBounds(baseBounds);
            } else {
                float dy = endP.getTo().y - endP.getFrom().y;
                float dx = endP.getTo().x - endP.getFrom().x;
                float len = (float)endP.getFrom().distance(endP.getTo());
                float scale = 120.0f / len;
                float x1 = (float)endP.getFrom().x + dx / 2.0f + dy * scale;
                float y1 = (float)endP.getFrom().y + dy / 2.0f + dx * scale;
                Point2D.Float control = new Point2D.Float(x1, y1);
                this.controlPoint = new Point((int)control.x, (int)control.y);
                Rectangle b = new Rectangle(this.controlPoint);
                b = b.union(baseBounds);
                this.setBounds(b);
                this.controlPoint.translate(-this.getLocation().x, -this.getLocation().y);
            }
        }
    }

    public Point getMidPoint() {
        PointPair pp = this.getConnectedPoints();
        if (this.getMode() == 0 || !this.isSelfEdge) {
            return new Point((pp.getFrom().x + pp.getTo().x) / 2, (pp.getFrom().y + pp.getTo().y) / 2);
        }
        Point virtualMid = this.midPoint(pp.getFrom(), pp.getTo());
        return this.midPoint(virtualMid, this.controlPoint);
    }

    private Point midPoint(Point p1, Point p2) {
        return new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
    }

    @Override
    public Polygon getClickRegion() {
        PointPair pp = this.getConnectedPoints();
        if (this.getMode() == 0 || !this.isSelfEdge) {
            this.clickRegion = super.getClickRegion();
        } else if (this.clickRegion == null && pp != null) {
            Point tempCPoint = new Point(this.controlPoint);
            Point arc1 = this.midPoint(pp.getFrom(), tempCPoint);
            Point arc2 = this.midPoint(tempCPoint, pp.getTo());
            Point mid = this.getMidPoint();
            float bisect_len = (float)tempCPoint.distance(mid);
            int bisect_x = (int)((float)(tempCPoint.x - mid.x) / bisect_len);
            int bisect_y = (int)((float)(tempCPoint.y - mid.y) / bisect_len);
            mid.translate(-(bisect_x *= 5), -(bisect_y *= 5));
            arc1.translate(bisect_x, bisect_y);
            arc2.translate(bisect_x, bisect_y);
            int[] xPoints = new int[]{pp.getFrom().x, arc1.x, arc2.x, pp.getTo().x, mid.x};
            int[] yPoints = new int[]{pp.getFrom().y, arc1.y, arc2.y, pp.getTo().y, mid.y};
            this.clickRegion = new Polygon(xPoints, yPoints, 5);
            this.setClickRegion(this.clickRegion);
        }
        return this.clickRegion;
    }
}

