/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.gene.editor.MultiGraphEdge;
import edu.cmu.tetradapp.gene.editor.TimesteppedFactor;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import edu.cmu.tetradapp.workbench.GraphNodeMeasured;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MultiGraphNode
extends GraphNodeMeasured {
    protected Color FUTURE_COLOR = new Color(255, 255, 153);
    private int timestep = 0;
    TimesteppedFactor factorGroup;
    Map modelToDisplay;

    public MultiGraphNode(TimesteppedFactor factorGroup, int timestep) {
        super(factorGroup.getName());
        this.factorGroup = factorGroup;
        this.modelToDisplay = new HashMap();
        this.setTimestep(timestep);
    }

    public void setTimestep(int timestep) {
        this.timestep = timestep;
    }

    public int getTimestep() {
        return this.timestep;
    }

    public TimesteppedFactor getFactorGroup() {
        return this.factorGroup;
    }

    public void synchEdges(SortedSet laggedFactors) {
        boolean iAmZero;
        TreeSet toRemove = new TreeSet(this.modelToDisplay.keySet());
        TreeSet toCreate = new TreeSet(laggedFactors);
        if (this.getFactorGroup().getEdgeMode() == 0) {
            if (this.getFactorGroup().getTimeMode() == 0) {
                if (this.getTimestep() != 0) {
                    toCreate.clear();
                }
            } else {
                int myTime = this.getTimestep();
                Iterator it = toCreate.iterator();
                while (it.hasNext()) {
                    LaggedFactor itm = (LaggedFactor)it.next();
                    if (myTime - itm.getLag() == 0) continue;
                    it.remove();
                }
            }
        }
        TreeSet toKeep = new TreeSet(toCreate);
        toCreate.removeAll(toRemove);
        toRemove.removeAll(toKeep);
        Iterator<Object> items = toRemove.iterator();
        while (items.hasNext()) {
            LaggedFactor itm = (LaggedFactor)items.next();
            this.getFactorGroup().getContainer().unbindEdge((DisplayEdge)this.modelToDisplay.get(itm));
            this.modelToDisplay.remove(itm);
            items.remove();
        }
        for (LaggedFactor lf : toCreate) {
            TimesteppedFactor factor = this.getFactorGroup().getContainer().getDisplayFactor(lf.getFactor());
            int lag = this.getTimestep() - lf.getLag();
            if (factor == null) continue;
            try {
                MultiGraphNode src = factor.getDisplayNode(lag);
                MultiGraphEdge displayEdge = new MultiGraphEdge(src, this);
                this.modelToDisplay.put(new LaggedFactor(lf), displayEdge);
                this.getFactorGroup().getContainer().bindEdge(displayEdge);
            }
            catch (IndexOutOfBoundsException e) {}
        }
        items = this.modelToDisplay.keySet().iterator();
        int myTime = this.getTimestep();
        boolean bl = iAmZero = myTime == 0;
        while (items.hasNext()) {
            LaggedFactor key = (LaggedFactor)items.next();
            MultiGraphEdge edge = (MultiGraphEdge)this.modelToDisplay.get(key);
            if (edge == null) {
                System.out.println(key + " doesn't have an associated edge");
            }
            if (this.getFactorGroup().getEdgeMode() == 2 || this.getFactorGroup().getEdgeMode() == 0) {
                edge.setVisibility(255);
            } else if (this.getFactorGroup().getTimeMode() == 0) {
                edge.setVisibility(iAmZero ? 255 : 32);
            } else {
                int srcTime = myTime - key.getLag();
                edge.setVisibility(srcTime == 0 ? 255 : 32);
            }
            edge.repaint();
        }
    }

    public void removeDisplayEdges() {
        Iterator items = this.modelToDisplay.values().iterator();
        while (items.hasNext()) {
            DisplayEdge itm = (DisplayEdge)items.next();
            this.getFactorGroup().getContainer().unbindEdge(itm);
            items.remove();
        }
    }

    @Override
    public void doDoubleClickAction() {
        JTextField nameField = new JTextField(8);
        nameField.setText(this.getName());
        nameField.setCaretPosition(0);
        nameField.moveCaretPosition(this.getName().length());
        JPanel message = new JPanel();
        message.add(new JLabel("Name:"));
        message.add(nameField);
        int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), message, "Factor Name", 2, -1);
        if (ret == 0) {
            String newName = nameField.getText();
            this.getFactorGroup().getContainer().getModelGraph().renameFactor(this.getName(), newName);
        }
    }

    protected String getDisplayString() {
        return this.getName() + ":" + Integer.toString(this.getTimestep());
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        int width = fm.stringWidth(this.getDisplayString()) + fm.getMaxAdvance();
        int height = 2 * DisplayNodeUtils.getPixelGap() + fm.getAscent() + 3;
        width = width < 60 ? 60 : width;
        return new Dimension(width, height);
    }

    @Override
    public void paint(Graphics g) {
        Color draw;
        Color fill;
        Graphics2D g2 = (Graphics2D)g;
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        int width = this.getPreferredSize().width;
        int stringWidth = fm.stringWidth(this.getName());
        int stringX = (width - stringWidth) / 2;
        int stringY = fm.getAscent() + DisplayNodeUtils.getPixelGap();
        if (super.isSelected()) {
            fill = DisplayNodeUtils.getNodeSelectedFillColor();
            draw = DisplayNodeUtils.getNodeSelectedEdgeColor();
        } else if (this.getTimestep() < 0) {
            int divisor = this.getFactorGroup().getPastSteps() + 1;
            int alpha = (int)(255.0f * ((float)(divisor + this.getTimestep()) / (float)divisor));
            fill = new Color(DisplayNodeUtils.getNodeFillColor().getRed(), DisplayNodeUtils.getNodeFillColor().getGreen(), DisplayNodeUtils.getNodeFillColor().getBlue(), alpha);
            draw = new Color(DisplayNodeUtils.getNodeEdgeColor().getRed(), DisplayNodeUtils.getNodeEdgeColor().getGreen(), DisplayNodeUtils.getNodeEdgeColor().getBlue(), alpha);
        } else if (this.getTimestep() > 0) {
            int divisor = this.getFactorGroup().getFutureSteps();
            int alpha = (int)(255.0f * ((float)(divisor - (this.getTimestep() - 1)) / (float)divisor));
            fill = new Color(this.FUTURE_COLOR.getRed(), this.FUTURE_COLOR.getGreen(), this.FUTURE_COLOR.getBlue(), alpha);
            draw = new Color(DisplayNodeUtils.getNodeEdgeColor().getRed(), DisplayNodeUtils.getNodeEdgeColor().getGreen(), DisplayNodeUtils.getNodeEdgeColor().getBlue(), alpha);
        } else {
            fill = DisplayNodeUtils.getNodeFillColor();
            draw = DisplayNodeUtils.getNodeEdgeColor();
        }
        g2.setColor(fill);
        g2.setColor(draw);
        g2.setColor(DisplayNodeUtils.getNodeTextColor());
        g2.drawString(this.getDisplayString(), stringX, stringY);
    }
}

