/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.gene.graph.StoredLagGraphParams;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StoredLagGraphParamsEditor
extends JPanel {
    StoredLagGraphParams params;

    public StoredLagGraphParamsEditor(StoredLagGraphParams params, Object[] parentModels) {
        if (params == null) {
            throw new NullPointerException("Params must not be null.");
        }
        this.params = params;
        File file = new File(params.getFilename());
        String filename = file == null ? "(Not set yet)" : file.getName();
        this.setLayout(new BoxLayout(this, 1));
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Current file to read from is:"));
        b1.add(Box.createGlue());
        this.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createGlue());
        b2.add(new JLabel(filename));
        this.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(Box.createGlue());
        JButton chooseFile = new JButton("Choose File");
        b3.add(chooseFile);
        this.add(b3);
        chooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = StoredLagGraphParamsEditor.this.getJFileChooser();
                chooser.showOpenDialog(StoredLagGraphParamsEditor.this);
                StoredLagGraphParamsEditor.this.setFile(chooser.getSelectedFile());
            }
        });
    }

    private JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("fileSaveLocation", "");
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.resetChoosableFileFilters();
        chooser.setFileSelectionMode(2);
        return chooser;
    }

    private void setFile(File file) {
        this.params.setFilename(file.getPath());
    }
}

