/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditorToolbar;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeGraph;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelEdge;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelNode;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeWorkbench;
import edu.cmu.tetradapp.knowledge_editor.ListTransferable;
import edu.cmu.tetradapp.knowledge_editor.OtherGroupsEditor;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KnowledgeBoxEditor
extends JPanel {
    private static final long serialVersionUID = 959706288096545158L;
    private List<String> varNames;
    private KnowledgeWorkbench edgeWorkbench;
    private JPanel tiersPanel;
    private boolean showForbiddenExplicitly = true;
    private boolean showForbiddenByTiers = true;
    private boolean showRequired = true;
    private boolean showRequiredByGroups = true;
    private boolean showForbiddenByGroups = true;
    private JTextArea textArea;
    private Graph sourceGraph;
    private Knowledge knowledge;
    private int numTiers = -1;
    private KnowledgeBoxModel knowledgeBoxModel;

    public KnowledgeBoxEditor(KnowledgeBoxModel knowledgeBoxModel) {
        this(knowledgeBoxModel.getKnowledge(), knowledgeBoxModel.getVarNames(), knowledgeBoxModel.getSourceGraph());
        this.knowledgeBoxModel = knowledgeBoxModel;
    }

    private KnowledgeBoxEditor(Knowledge knowledge, List<String> varNames, Graph sourceGraph) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        if (varNames == null) {
            varNames = new ArrayList<String>();
        }
        this.knowledge = knowledge;
        this.varNames = varNames;
        this.sourceGraph = sourceGraph;
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Tiers", this.tierDisplay());
        tabbedPane.add("Other Groups", new OtherGroupsEditor(knowledge, varNames));
        tabbedPane.add("Edges", this.edgeDisplay());
        tabbedPane.add("Text", this.textDisplay());
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                if (pane.getSelectedIndex() == 0) {
                    KnowledgeBoxEditor.this.setNumDisplayTiers(KnowledgeBoxEditor.this.getNumTiers());
                } else if (pane.getSelectedIndex() == 2) {
                    KnowledgeBoxEditor.this.resetEdgeDisplay();
                } else if (pane.getSelectedIndex() == 3) {
                    KnowledgeBoxEditor.this.resetTextDisplay();
                }
            }
        });
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(new Dimension(550, 500));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TetradLogger.getInstance().log("knowledge", "Edited Knowledge:");
                TetradLogger.getInstance().log("knowledge", KnowledgeBoxEditor.this.knowledge.toString());
            }
        });
    }

    private Box tierDisplay() {
        if (this.numTiers < 0) {
            int _default;
            int numTiers = this.getKnowledge().getNumTiers();
            this.numTiers = numTiers = numTiers < (_default = (int)(Math.pow(this.varNames.size(), 0.5) + 1.0)) ? _default : numTiers;
        }
        Box b = Box.createVerticalBox();
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Not in tier:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("# Tiers = "));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.getNumTiers(), 0, 100, 1);
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int knowledgeNumTiers;
                SpinnerNumberModel model = (SpinnerNumberModel)e.getSource();
                int numTiers = model.getNumber().intValue();
                if (numTiers >= (knowledgeNumTiers = KnowledgeBoxEditor.this.getKnowledge().getNumTiers())) {
                    KnowledgeBoxEditor.this.setNumDisplayTiers(numTiers);
                    KnowledgeBoxEditor.this.setNumTiers(numTiers);
                } else {
                    model.setValue(knowledgeNumTiers);
                    KnowledgeBoxEditor.this.setNumTiers(knowledgeNumTiers);
                }
                for (int i = KnowledgeBoxEditor.this.getNumTiers(); i <= KnowledgeBoxEditor.this.getKnowledge().getMaxTierForbiddenWithin(); ++i) {
                    KnowledgeBoxEditor.this.getKnowledge().setTierForbiddenWithin(i, false);
                }
                KnowledgeBoxEditor.this.notifyKnowledge();
            }
        });
        JSpinner spinner = new JSpinner(spinnerNumberModel);
        spinner.setMaximumSize(spinner.getPreferredSize());
        b1.add(spinner);
        b.add(b1);
        this.tiersPanel = new JPanel();
        this.tiersPanel.setLayout(new BorderLayout());
        this.tiersPanel.add((Component)this.getTierBoxes(this.getNumTiers()), "Center");
        b.add(this.tiersPanel);
        Box c = Box.createHorizontalBox();
        c.add(new JLabel("Use shift key to select multiple items."));
        c.add(Box.createGlue());
        b.add(c);
        return b;
    }

    private void setNumDisplayTiers(int numTiers) {
        if (numTiers < 0) {
            int defaultTiers;
            int knowledgeTiers = this.getKnowledge().getNumTiers();
            numTiers = knowledgeTiers < (defaultTiers = (int)(Math.pow(this.getVarNames().size(), 0.5) + 1.0)) ? defaultTiers : knowledgeTiers;
            this.setNumTiers(numTiers);
        } else {
            this.setNumTiers(numTiers);
        }
        this.tiersPanel.removeAll();
        this.tiersPanel.add((Component)this.getTierBoxes(this.getNumTiers()), "Center");
        this.tiersPanel.revalidate();
        this.tiersPanel.repaint();
    }

    private Box getTierBoxes(int numTiers) {
        Box c = Box.createVerticalBox();
        List<String> varsNotInTiers = this.getKnowledge().getVarsNotInTier();
        DragDropList l1 = new DragDropList(varsNotInTiers, -1);
        l1.setBorder(null);
        Box b2 = Box.createHorizontalBox();
        JScrollPane jScrollPane1 = new JScrollPane(l1);
        jScrollPane1.setPreferredSize(new Dimension(500, 50));
        b2.add(jScrollPane1);
        c.add(b2);
        c.add(Box.createVerticalStrut(5));
        Box d = Box.createVerticalBox();
        for (int tier = 0; tier < numTiers; ++tier) {
            Box textRow = Box.createHorizontalBox();
            textRow.add(new JLabel("Tier " + (tier + 1)));
            final int _tier = tier;
            JCheckBox exogenousCheckbox = new JCheckBox("Forbid Within Tier", this.getKnowledge().isTierForbiddenWithin(_tier));
            exogenousCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox checkbox = (JCheckBox)e.getSource();
                    KnowledgeBoxEditor.this.getKnowledge().setTierForbiddenWithin(_tier, checkbox.isSelected());
                    KnowledgeBoxEditor.this.notifyKnowledge();
                }
            });
            textRow.add(Box.createHorizontalGlue());
            textRow.add(exogenousCheckbox);
            d.add(textRow);
            List<String> tierNames = this.getKnowledge().getTier(tier);
            DragDropList tierList = new DragDropList(tierNames, tier);
            Box tierRow = Box.createHorizontalBox();
            JScrollPane jScrollPane = new JScrollPane(tierList);
            jScrollPane.setPreferredSize(new Dimension(500, 50));
            tierRow.add(jScrollPane);
            d.add(tierRow);
        }
        JScrollPane scroll = new JScrollPane(d);
        scroll.setPreferredSize(new Dimension(550, 400));
        c.add(scroll);
        return c;
    }

    private JPanel edgeDisplay() {
        KnowledgeGraph graph = new KnowledgeGraph(this.getKnowledge());
        graph.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modelChanged".equals(evt.getPropertyName())) {
                    KnowledgeBoxEditor.this.notifyKnowledge();
                }
            }
        });
        this.edgeWorkbench = new KnowledgeWorkbench(graph);
        this.resetEdgeDisplay();
        JCheckBox showForbiddenByTiersCheckbox = new JCheckBox("Show Forbidden By Tiers", this.showForbiddenExplicitly);
        JCheckBox showForbiddenExplicitlyCheckbox = new JCheckBox("Show Forbidden Explicitly", this.showForbiddenExplicitly);
        JCheckBox showRequiredCheckbox = new JCheckBox("Show Required Explicitly", this.showRequired);
        JCheckBox showRequiredGroupsCheckBox = new JCheckBox("Show Required by Groups", this.showRequiredByGroups);
        JCheckBox showForbiddenGroupsCheckBox = new JCheckBox("Show Forbidden by Groups", this.showForbiddenByGroups);
        showRequiredGroupsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                KnowledgeBoxEditor.this.showRequiredByGroups = box.isSelected();
                KnowledgeBoxEditor.this.resetEdgeDisplay();
            }
        });
        showForbiddenGroupsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                KnowledgeBoxEditor.this.showForbiddenByGroups = box.isSelected();
                KnowledgeBoxEditor.this.resetEdgeDisplay();
            }
        });
        showForbiddenByTiersCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                KnowledgeBoxEditor.this.setShowForbiddenByTiers(checkBox.isSelected());
                KnowledgeBoxEditor.this.resetEdgeDisplay();
            }
        });
        showForbiddenExplicitlyCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                KnowledgeBoxEditor.this.setShowForbiddenExplicitly(checkBox.isSelected());
                KnowledgeBoxEditor.this.resetEdgeDisplay();
            }
        });
        showRequiredCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                KnowledgeBoxEditor.this.setShowRequired(checkBox.isSelected());
                KnowledgeBoxEditor.this.resetEdgeDisplay();
            }
        });
        JPanel workbenchPanel = new JPanel();
        workbenchPanel.setLayout(new BorderLayout());
        workbenchPanel.add((Component)new JScrollPane(this.edgeWorkbench), "Center");
        workbenchPanel.setBorder(new TitledBorder("Forbidden and Required Edges"));
        JPanel display = new JPanel();
        display.setPreferredSize(new Dimension(550, 450));
        display.setLayout(new BorderLayout());
        KnowledgeEditorToolbar b2 = new KnowledgeEditorToolbar(this.edgeWorkbench, this.getSourceGraph());
        display.add((Component)b2, "West");
        display.add((Component)workbenchPanel, "Center");
        Box vBox = Box.createVerticalBox();
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createHorizontalGlue());
        b4.add(showForbiddenByTiersCheckbox);
        b4.add(showForbiddenExplicitlyCheckbox);
        b4.add(showRequiredCheckbox);
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalGlue());
        hBox.add(showRequiredGroupsCheckBox);
        hBox.add(showForbiddenGroupsCheckBox);
        vBox.add(b4);
        vBox.add(hBox);
        display.add((Component)vBox, "South");
        return display;
    }

    private void resetEdgeDisplay() {
        boolean arrangedAll;
        KnowledgeEdge pair;
        KnowledgeModelNode toNode;
        KnowledgeModelNode fromNode;
        String to;
        String from;
        KnowledgeEdge edge;
        Iterator<KnowledgeEdge> i;
        List<String> varNames = this.getVarNames();
        Knowledge knowledge = this.getKnowledge();
        KnowledgeGraph graph = new KnowledgeGraph(this.getKnowledge());
        for (String varName : varNames) {
            graph.addNode(new KnowledgeModelNode(varName));
        }
        if (this.showRequiredByGroups) {
            i = knowledge.requiredEdgesIterator();
            while (i.hasNext()) {
                edge = i.next();
                from = edge.getFrom();
                if (!knowledge.edgeRequiredByGroups(from, to = edge.getTo())) continue;
                fromNode = (KnowledgeModelNode)graph.getNode(from);
                toNode = (KnowledgeModelNode)graph.getNode(to);
                graph.addEdge(new KnowledgeModelEdge(fromNode, toNode, 4));
            }
        }
        if (this.showForbiddenByGroups) {
            i = knowledge.forbiddenEdgesIterator();
            while (i.hasNext()) {
                edge = i.next();
                from = edge.getFrom();
                if (!knowledge.edgeForbiddenByGroups(from, to = edge.getTo())) continue;
                fromNode = (KnowledgeModelNode)graph.getNode(from);
                toNode = (KnowledgeModelNode)graph.getNode(to);
                graph.addEdge(new KnowledgeModelEdge(fromNode, toNode, 3));
            }
        }
        if (this.showRequired) {
            i = knowledge.explicitlyRequiredEdgesIterator();
            while (i.hasNext()) {
                pair = i.next();
                from = pair.getFrom();
                to = pair.getTo();
                fromNode = (KnowledgeModelNode)graph.getNode(from);
                toNode = (KnowledgeModelNode)graph.getNode(to);
                graph.addEdge(new KnowledgeModelEdge(fromNode, toNode, 2));
            }
        }
        if (this.showForbiddenByTiers) {
            i = knowledge.forbiddenEdgesIterator();
            while (i.hasNext()) {
                pair = i.next();
                from = pair.getFrom();
                if (!knowledge.isForbiddenByTiers(from, to = pair.getTo())) continue;
                fromNode = (KnowledgeModelNode)graph.getNode(from);
                toNode = (KnowledgeModelNode)graph.getNode(to);
                if (fromNode == null) {
                    graph.addNode(new KnowledgeModelNode(from));
                    fromNode = (KnowledgeModelNode)graph.getNode(from);
                }
                if (toNode == null) {
                    graph.addNode(new KnowledgeModelNode(to));
                    toNode = (KnowledgeModelNode)graph.getNode(to);
                }
                KnowledgeModelEdge knowledgeModelEdge = new KnowledgeModelEdge(fromNode, toNode, 1);
                graph.addEdge(knowledgeModelEdge);
            }
        }
        if (this.showForbiddenExplicitly) {
            i = knowledge.explicitlyForbiddenEdgesIterator();
            while (i.hasNext()) {
                pair = i.next();
                from = pair.getFrom();
                to = pair.getTo();
                fromNode = (KnowledgeModelNode)graph.getNode(from);
                KnowledgeModelEdge edge2 = new KnowledgeModelEdge(fromNode, toNode = (KnowledgeModelNode)graph.getNode(to), 0);
                if (graph.containsEdge(edge2)) continue;
                graph.addEdge(edge2);
            }
        }
        if (!(arrangedAll = GraphUtils.arrangeBySourceGraph(graph, this.edgeWorkbench.getGraph()))) {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.edgeWorkbench.setGraph(graph);
        if (this.knowledgeBoxModel != null) {
            this.notifyKnowledge();
        }
    }

    private Component textDisplay() {
        JButton testButton = new JButton("Test");
        JButton loadButton = new JButton("Load");
        testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String text = KnowledgeBoxEditor.this.getTextArea().getText();
                    DataReader reader = new DataReader();
                    reader.parseKnowledge(text.toCharArray());
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Looks good.");
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e1.getMessage());
                }
            }
        });
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String text = KnowledgeBoxEditor.this.getTextArea().getText();
                    DataReader reader = new DataReader();
                    Knowledge knowledge = reader.parseKnowledge(text.toCharArray());
                    KnowledgeBoxEditor.this.notifyKnowledge();
                    KnowledgeBoxEditor.this.setNumTiers(-1);
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Loaded.");
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e1.getMessage());
                }
            }
        });
        Box b = Box.createVerticalBox();
        this.textArea = new JTextArea();
        this.resetTextDisplay();
        b.add(this.getTextArea());
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(testButton);
        b2.add(loadButton);
        b.add(b2);
        return b;
    }

    private void notifyKnowledge() {
        if (this.knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledgeBoxModel.setKnowledge(this.knowledge);
        this.firePropertyChange("modelChanged", null, null);
    }

    public void resetTextDisplay() {
        this.getTextArea().setFont(new Font("Monospaced", 0, 12));
        this.getTextArea().setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(3, 3, 3, 3)));
        try {
            Knowledge knowledge = this.getKnowledge();
            CharArrayWriter out = new CharArrayWriter();
            Knowledge.saveKnowledge(knowledge, out);
            this.getTextArea().setText(out.toString());
        }
        catch (IOException e) {
            this.getTextArea().setText("Could not render knowledge.");
        }
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    public boolean isShowForbiddenExplicitly() {
        return this.showForbiddenExplicitly;
    }

    public void setShowForbiddenExplicitly(boolean showForbiddenExplicitly) {
        this.showForbiddenExplicitly = showForbiddenExplicitly;
    }

    public boolean isShowRequired() {
        return this.showRequired;
    }

    public void setShowRequired(boolean showRequired) {
        this.showRequired = showRequired;
    }

    public boolean isShowForbiddenByTiers() {
        return this.showForbiddenByTiers;
    }

    public void setShowForbiddenByTiers(boolean showForbiddenByTiers) {
        this.showForbiddenByTiers = showForbiddenByTiers;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public int getNumTiers() {
        return this.numTiers;
    }

    public void setNumTiers(int numTiers) {
        this.numTiers = numTiers;
    }

    public Graph getSourceGraph() {
        return this.sourceGraph;
    }

    public static final class MyDragGestureRecognizer
    extends DragGestureRecognizer {
        public MyDragGestureRecognizer(DragSource ds) {
            super(ds);
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }

        @Override
        protected synchronized void appendEvent(InputEvent awtie) {
            super.appendEvent(awtie);
        }
    }

    public class DragDropList
    extends JList
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private List movedList;
        private int tier;

        public DragDropList(List items, int tier) {
            if (tier < -1) {
                throw new IllegalArgumentException();
            }
            this.tier = tier;
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(0);
            this.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Color fillColor = new Color(153, 204, 204);
                    Color selectedFillColor = new Color(255, 204, 102);
                    JLabel comp = new JLabel(" " + value + " ");
                    comp.setOpaque(true);
                    if (isSelected) {
                        comp.setForeground(Color.BLACK);
                        comp.setBackground(selectedFillColor);
                    } else {
                        comp.setForeground(Color.BLACK);
                        comp.setBackground(fillColor);
                    }
                    comp.setHorizontalAlignment(0);
                    comp.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE), new LineBorder(Color.BLACK)));
                    return comp;
                }
            });
            new DropTarget(this, 2, this, true);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.setModel(new DefaultListModel());
            for (Object item : items) {
                ((DefaultListModel)this.getModel()).addElement(item);
            }
        }

        public int getTier() {
            return this.tier;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.getSelectedIndex() == -1) {
                return;
            }
            Object[] selectedValues = this.getSelectedValues();
            List<Object> list = Arrays.asList(selectedValues);
            if (list == null) {
                this.getToolkit().beep();
            } else {
                this.movedList = list;
                ListTransferable transferable = new ListTransferable(list);
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable tr = dropTargetDropEvent.getTransferable();
                DataFlavor flavor = tr.getTransferDataFlavors()[0];
                List list = (List)tr.getTransferData(flavor);
                for (String name : list) {
                    DefaultListModel model;
                    if (this.getTier() >= 0) {
                        try {
                            KnowledgeBoxEditor.this.getKnowledge().addToTier(this.getTier(), name);
                            KnowledgeBoxEditor.this.notifyKnowledge();
                            model = (DefaultListModel)this.getModel();
                            model.addElement(name);
                            this.sort(model);
                            dropTargetDropEvent.dropComplete(true);
                        }
                        catch (IllegalStateException e) {
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e.getMessage());
                            dropTargetDropEvent.dropComplete(false);
                        }
                        continue;
                    }
                    KnowledgeBoxEditor.this.getKnowledge().removeFromTiers(name);
                    KnowledgeBoxEditor.this.notifyKnowledge();
                    model = (DefaultListModel)this.getModel();
                    model.addElement(name);
                    this.sort(model);
                    dropTargetDropEvent.dropComplete(true);
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                return;
            }
            if (this.movedList != null) {
                for (Object aMovedList : this.movedList) {
                    ((DefaultListModel)this.getModel()).removeElement(aMovedList);
                }
                this.movedList = null;
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        private void sort(DefaultListModel model) {
            Object[] elements = model.toArray();
            Arrays.sort(elements);
            model.clear();
            for (Object element : elements) {
                model.addElement(element);
            }
        }
    }
}

