/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class KnowledgeDisplayNode
extends DisplayNode {
    public KnowledgeDisplayNode(Node modelNode) {
        this.setModelNode(modelNode);
        this.setBackground(DisplayNodeUtils.getNodeFillColor());
        this.setFont(DisplayNodeUtils.getFont());
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getShape().contains(x, y);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        int width = fm.stringWidth(this.getName()) + 11;
        int height = fm.getMaxAscent() + 6;
        return new Dimension(width, height);
    }

    public Shape getShape() {
        return new Rectangle2D.Double(0.0, 0.0, this.getPreferredSize().width - 1, this.getPreferredSize().height - 1);
    }

    @Override
    public void doDoubleClickAction(Graph graph) {
        String newName;
        List<Node> nodes = graph.getNodes();
        JCheckBox latentCheckBox = new JCheckBox("Latent", false);
        block0: while (true) {
            JTextField nameField = new JTextField(8);
            nameField.setText(this.getName());
            nameField.setCaretPosition(0);
            nameField.moveCaretPosition(this.getName().length());
            JPanel message = new JPanel();
            message.add(new JLabel("Name:"));
            message.add(nameField);
            message.add(latentCheckBox);
            JOptionPane pane = new JOptionPane(message, -1, 2);
            JDialog dialog = pane.createDialog(this, "Node Properties");
            dialog.pack();
            dialog.setVisible(true);
            newName = nameField.getText();
            if (!NamingProtocol.isLegalName(newName)) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), NamingProtocol.getProtocolDescription());
                continue;
            }
            if (nodes == null) break;
            for (Node node : nodes) {
                if (!newName.equals(((Object)node).toString()) || newName.equals(super.getModelNode().getName())) continue;
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "The name '" + newName + "' is already being used." + "\nPlease choose another name.");
                continue block0;
            }
            break;
        }
        boolean changed = false;
        if (super.getModelNode() != null) {
            super.getModelNode().setName(newName);
            changed = true;
        }
        if (latentCheckBox.isSelected()) {
            super.getModelNode().setNodeType(NodeType.LATENT);
            this.firePropertyChange("resetGraph", null, null);
            changed = true;
        }
        if (changed) {
            this.firePropertyChange("editingValueChanged", null, null);
        }
    }

    @Override
    public void doDoubleClickAction() {
        this.doDoubleClickAction(null);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        int stringX = 6;
        int stringY = fm.getMaxAscent() + 1;
        g2.setColor(this.isSelected() ? DisplayNodeUtils.getNodeSelectedFillColor() : DisplayNodeUtils.getNodeFillColor());
        g2.fill(this.getShape());
        g2.setColor(Color.BLACK);
        g2.draw(this.getShape());
        g2.setColor(Color.BLACK);
        g2.drawString(this.getName(), stringX, stringY);
    }
}

