/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeDisplayEdge;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeDisplayNode;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeGraph;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelEdge;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeModelNode;
import edu.cmu.tetradapp.workbench.AbstractWorkbench;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class KnowledgeWorkbench
extends AbstractWorkbench {
    public static final int FORBIDDEN_EDGE = 0;
    public static final int REQUIRED_EDGE = 2;
    private int edgeMode = 0;

    public KnowledgeWorkbench(KnowledgeGraph graph) {
        super(graph);
        this.setNodeEdgeErrorsReported(true);
        this.setRightClickPopupAllowed(false);
        this.setAllowEdgeReorientations(false);
    }

    public int getEdgeMode() {
        return this.edgeMode;
    }

    @Override
    public Node getNewModelNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DisplayNode getNewDisplayNode(Node modelNode) {
        KnowledgeDisplayNode displayNode = new KnowledgeDisplayNode(modelNode);
        displayNode.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("resetGraph".equals(evt.getPropertyName())) {
                    KnowledgeWorkbench.this.setGraph(KnowledgeWorkbench.this.getGraph());
                } else if ("editingValueChanged".equals(evt.getPropertyName())) {
                    KnowledgeWorkbench.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
        return displayNode;
    }

    @Override
    public Edge getNewModelEdge(Node node1, Node node2) {
        KnowledgeModelNode _node1 = (KnowledgeModelNode)node1;
        KnowledgeModelNode _node2 = (KnowledgeModelNode)node2;
        switch (this.edgeMode) {
            case 0: {
                return new KnowledgeModelEdge(_node1, _node2, 0);
            }
            case 2: {
                return new KnowledgeModelEdge(_node1, _node2, 2);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IDisplayEdge getNewDisplayEdge(Edge modelEdge) {
        Node node2;
        Node node1 = modelEdge.getNode1();
        if (node1 == (node2 = modelEdge.getNode2())) {
            throw new IllegalArgumentException("Edges to self not supported.");
        }
        DisplayNode displayNodeA = (DisplayNode)this.getModelToDisplay().get(node1);
        DisplayNode displayNodeB = (DisplayNode)this.getModelToDisplay().get(node2);
        if (displayNodeA == null || displayNodeB == null) {
            return null;
        }
        return new KnowledgeDisplayEdge(modelEdge, displayNodeA, displayNodeB);
    }

    @Override
    public IDisplayEdge getNewTrackingEdge(DisplayNode node, Point mouseLoc) {
        switch (this.edgeMode) {
            case 0: {
                return new KnowledgeDisplayEdge(node, mouseLoc, 3);
            }
            case 2: {
                return new KnowledgeDisplayEdge(node, mouseLoc, 5);
            }
        }
        throw new IllegalStateException();
    }

    public String nextVariableName(String base) {
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (Node node1 : this.getGraph().getNodes()) {
                if (!node1.getName().equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    public void setEdgeMode(int edgeMode) {
        switch (edgeMode) {
            case 0: 
            case 2: {
                this.edgeMode = edgeMode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

