/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.SearchParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAlgorithmRunner
implements AlgorithmRunner,
ParamsResettable,
Unmarshallable {
    static final long serialVersionUID = 23L;
    private String name;
    private SearchParams params;
    private DataModel dataModel;
    private DataModelList dataModelList;
    private Graph sourceGraph;
    private Graph resultGraph;

    public AbstractAlgorithmRunner(DataWrapper dataWrapper, SearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.sourceGraph = dataWrapper.getSourceGraph();
        DataModel dataSource = this.getSelectedDataModel(dataWrapper);
        if (knowledgeBoxModel == null) {
            this.getParams().setKnowledge(dataWrapper.getKnowledge());
        } else {
            this.getParams().setKnowledge(knowledgeBoxModel.getKnowledge());
        }
        List<String> names = dataSource.getVariableNames();
        this.transferVarNamesToParams(names);
        new IndTestFactory().adjustIndTestParams(dataSource, params);
        this.dataModel = dataSource;
        this.setDataModelList(dataWrapper.getDataModelList());
    }

    public AbstractAlgorithmRunner(Graph sourceGraph, SearchParams params) {
        if (sourceGraph == null) {
            throw new NullPointerException("Source graph must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Params must not be null.");
        }
        this.params = params;
        List<String> names = this.measuredNames(sourceGraph);
        this.transferVarNamesToParams(names);
        new IndTestFactory().adjustIndTestParams(sourceGraph, params);
        this.sourceGraph = sourceGraph;
    }

    public AbstractAlgorithmRunner(Graph graph, SearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        this(graph, params);
        if (knowledgeBoxModel != null) {
            this.getParams().setKnowledge(knowledgeBoxModel.getKnowledge());
        }
    }

    @Override
    public final Graph getResultGraph() {
        return this.resultGraph;
    }

    @Override
    public boolean supportsKnowledge() {
        return false;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        return null;
    }

    @Override
    public final Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public final DataModel getDataModel() {
        return this.dataModel;
    }

    public final void setResultGraph(Graph resultGraph) {
        this.resultGraph = resultGraph;
    }

    @Override
    public final SearchParams getParams() {
        return this.params;
    }

    @Override
    public Object getResettableParams() {
        return this.getParams();
    }

    @Override
    public void resetParams(Object params) {
        this.params = (SearchParams)params;
    }

    public DataModel getSelectedDataModel(DataWrapper dataWrapper) {
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataModelList) {
            DataModelList dataModelList = (DataModelList)dataModel;
            dataModel = dataModelList.getSelectedModel();
            return dataModel;
        }
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (dataSet.isDiscrete()) {
                return dataSet;
            }
            if (dataSet.isContinuous()) {
                return dataSet;
            }
            throw new IllegalArgumentException("<html>This data set contains a mixture of discrete and continuous <br>columns; there are no algorithms in Tetrad currently to <br>search over such data sets.</html>");
        }
        if (dataModel instanceof CovarianceMatrix) {
            return dataModel;
        }
        if (dataModel instanceof TimeSeriesData) {
            return dataModel;
        }
        throw new IllegalArgumentException("Unexpected dataModel source: " + dataModel);
    }

    private List<String> measuredNames(Graph graph) {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            names.add(node.getName());
        }
        return names;
    }

    private void transferVarNamesToParams(List names) {
        this.getParams().setVarNames(names);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getParams() == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public DataModelList getDataModelList() {
        return this.dataModelList;
    }

    public void setDataModelList(DataModelList dataModelList) {
        this.dataModelList = dataModelList;
    }
}

