/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.model.HasCalculatorParams;
import edu.cmu.tetradapp.model.calculator.CalculatorParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.prefs.Preferences;

public class BayesDataParams
implements Params,
HasCalculatorParams {
    static final long serialVersionUID = 23L;
    private int sampleSize = Preferences.userRoot().getInt("sampleSize", 1000);
    private boolean latentDataSaved = Preferences.userRoot().getBoolean("latentDataSaved", false);
    private boolean positiveDataOnly = Preferences.userRoot().getBoolean("positiveDataOnly", false);
    private CalculatorParams calculatorParams;

    public static BayesDataParams serializableInstance() {
        return new BayesDataParams();
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("Sample size must be > 0: " + sampleSize);
        }
        this.sampleSize = sampleSize;
    }

    public boolean isLatentDataSaved() {
        return this.latentDataSaved;
    }

    public void setLatentDataSaved(boolean latentDataSaved) {
        this.latentDataSaved = latentDataSaved;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sampleSize <= 0) {
            throw new IllegalStateException("Sample size out of range: " + this.sampleSize);
        }
    }

    @Override
    public CalculatorParams getCalculatorParams() {
        return this.calculatorParams;
    }
}

