/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesEstimator;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BayesEstimatorWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesIm bayesIm;
    private DataSet dataSet;

    public BayesEstimatorWrapper(DataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException("BayesDataWrapper must not be null.");
        }
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null");
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        BayesPm bayesPm = bayesPmWrapper.getBayesPm();
        this.dataSet = dataSet;
        this.estimate(dataSet, bayesPm);
        this.log(this.bayesIm);
    }

    public BayesEstimatorWrapper(DataWrapper dataWrapper, BayesImWrapper bayesImWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException("BayesDataWrapper must not be null.");
        }
        if (bayesImWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null");
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        BayesPm bayesPm = bayesImWrapper.getBayesIm().getBayesPm();
        this.estimate(dataSet, bayesPm);
        this.log(this.bayesIm);
    }

    public static BayesEstimatorWrapper serializableInstance() {
        return new BayesEstimatorWrapper(DataWrapper.serializableInstance(), BayesPmWrapper.serializableInstance());
    }

    public BayesIm getEstimatedBayesIm() {
        return this.bayesIm;
    }

    private void estimate(DataSet DataSet2, BayesPm bayesPm) {
        Dag graph = bayesPm.getDag();
        for (Node o : graph.getNodes()) {
            Node node = o;
            if (node.getNodeType() != NodeType.LATENT) continue;
            throw new IllegalArgumentException("Estimation of Bayes IM's with latents is not supported.");
        }
        try {
            MlBayesEstimator estimator = new MlBayesEstimator();
            this.bayesIm = estimator.estimate(bayesPm, DataSet2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("Value assignments between Bayes PM and discrete data set do not match.");
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
        if (this.dataSet == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.bayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(BayesIm im) {
        TetradLogger.getInstance().log("info", "ML estimated Bayes IM.");
        TetradLogger.getInstance().log("im", ((Object)im).toString());
    }
}

