/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.search.BayesUpdaterClassifier;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BayesUpdaterClassifierWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private BayesUpdaterClassifier classifier;
    private String name;

    public BayesUpdaterClassifierWrapper(BayesImWrapper bayesImWrapper, DataWrapper dataWrapper) {
        if (bayesImWrapper == null) {
            throw new NullPointerException();
        }
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        BayesIm bayesIm = bayesImWrapper.getBayesIm();
        this.classifier = new BayesUpdaterClassifier(bayesIm, dataSet);
    }

    public BayesUpdaterClassifierWrapper(DirichletBayesImWrapper bayesImWrapper, DataWrapper dataWrapper) {
        if (bayesImWrapper == null) {
            throw new NullPointerException();
        }
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        DirichletBayesIm bayesIm = bayesImWrapper.getDirichletBayesIm();
        this.classifier = new BayesUpdaterClassifier(bayesIm, dataSet);
    }

    public static BayesUpdaterClassifierWrapper serializableInstance() {
        return new BayesUpdaterClassifierWrapper(BayesImWrapper.serializableInstance(), DataWrapper.serializableInstance());
    }

    public BayesUpdaterClassifier getClassifier() {
        return this.classifier;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.classifier == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

