/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Ccd2;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BasicSearchParams;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.ArrayList;
import java.util.List;

public class CcdRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public CcdRunner(DataWrapper dataWrapper, BasicSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public CcdRunner(DataWrapper dataWrapper, KnowledgeBoxModel knowledgeBoxModel, BasicSearchParams params) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public CcdRunner(GraphSource graphWrapper, KnowledgeBoxModel knowledgeBoxModel, PcSearchParams params) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public CcdRunner(GraphSource graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), (SearchParams)params, null);
    }

    public CcdRunner(GraphWrapper graphWrapper, BasicSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public CcdRunner(GraphWrapper graphWrapper, KnowledgeBoxModel knowledgeBoxModel, BasicSearchParams params) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public CcdRunner(DagWrapper dagWrapper, BasicSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public CcdRunner(DagWrapper dagWrapper, KnowledgeBoxModel knowledgeBoxModel, BasicSearchParams params) {
        super(dagWrapper.getDag(), (SearchParams)params, knowledgeBoxModel);
    }

    public CcdRunner(SemGraphWrapper dagWrapper, BasicSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public CcdRunner(SemGraphWrapper dagWrapper, KnowledgeBoxModel knowledgeBoxModel, BasicSearchParams params) {
        super(dagWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public static CcdRunner serializableInstance() {
        return new CcdRunner(DataWrapper.serializableInstance(), KnowledgeBoxModel.serializableInstance(), BasicSearchParams.serializableInstance());
    }

    @Override
    public void execute() {
        Knowledge knowledge = this.getParams().getKnowledge();
        Ccd2 ccd = new Ccd2(this.getIndependenceTest(), knowledge);
        ccd.setDepth(this.getParams().getIndTestParams().getDepth());
        Graph graph = ccd.search();
        if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        }
        this.setResultGraph(graph);
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        BasicSearchParams params = (BasicSearchParams)this.getParams();
        IndTestType testType = params.getIndTestType();
        return new IndTestFactory().getTest(dataModel, params, testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Underlines");
        names.add("Dotted Underlines");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getUnderlinedTriplesFromGraph(node, graph));
        triplesList.add(GraphUtils.getDottedUnderlinedTriplesFromGraph(node, graph));
        return triplesList;
    }
}

