/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Icpc;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.LinkedList;
import java.util.List;

public class CpcIterativeRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;
    private Graph trueGraph;

    public CpcIterativeRunner(DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public CpcIterativeRunner(DataWrapper dataWrapper, GraphWrapper graphWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
        this.trueGraph = graphWrapper.getGraph();
    }

    public CpcIterativeRunner(Graph graph, PcSearchParams params) {
        super(graph, params);
    }

    public CpcIterativeRunner(GraphWrapper graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public CpcIterativeRunner(DagWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public CpcIterativeRunner(SemGraphWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public static PcRunner serializableInstance() {
        return new PcRunner((Graph)Dag.serializableInstance(), PcSearchParams.serializableInstance());
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    @Override
    public void execute() {
        Knowledge knowledge = this.getParams().getKnowledge();
        int depth = this.getParams().getIndTestParams().getDepth();
        Icpc icpc = new Icpc(this.getIndependenceTest());
        icpc.setKnowledge(knowledge);
        icpc.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        icpc.setDepth(depth);
        icpc.setTrueGraph(this.trueGraph);
        Graph graph = icpc.search();
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = this.getParams().getIndTestType();
        return new IndTestFactory().getTest(dataModel, this.getParams(), testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    private boolean isAggressivelyPreventCycles() {
        SearchParams params = this.getParams();
        if (params instanceof MeekSearchParams) {
            return ((MeekSearchParams)params).isAggressivelyPreventCycles();
        }
        return false;
    }
}

