/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.bayes.DirichletEstimator;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesDataWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImParams;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class DirichletBayesImWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private DirichletBayesIm dirichletBayesIm;

    public DirichletBayesImWrapper(BayesPmWrapper bayesPmWrapper, DirichletBayesImParams params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Params must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        if (params.getInitializationMode() == 0) {
            this.dirichletBayesIm = DirichletBayesIm.blankDirichletIm(bayesPm);
        } else if (params.getInitializationMode() == 1) {
            this.dirichletBayesIm = DirichletBayesIm.symmetricDirichletIm(bayesPm, params.getSymmetricAlpha());
        }
        this.log(this.dirichletBayesIm);
    }

    public DirichletBayesImWrapper(BayesPmWrapper bayesPmWrapper, DirichletBayesImWrapper oldBayesImwrapper, DirichletBayesImParams params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Params must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        DirichletBayesIm oldBayesIm = oldBayesImwrapper.getDirichletBayesIm();
        if (params.getInitializationMode() == 0) {
            this.dirichletBayesIm = DirichletBayesIm.symmetricDirichletIm(bayesPm, oldBayesIm, 0.0);
        } else if (params.getInitializationMode() == 1) {
            this.dirichletBayesIm = DirichletBayesIm.symmetricDirichletIm(bayesPm, oldBayesIm, params.getSymmetricAlpha());
        }
        this.log(this.dirichletBayesIm);
    }

    public DirichletBayesImWrapper(BayesPmWrapper bayesPmWrapper, DataWrapper dataWrapper) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException();
        }
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        DirichletBayesIm emptyPrior = DirichletBayesIm.blankDirichletIm(bayesPm);
        DirichletEstimator estimator = new DirichletEstimator();
        this.dirichletBayesIm = DirichletEstimator.estimate(emptyPrior, dataSet);
        this.log(this.dirichletBayesIm);
    }

    public DirichletBayesImWrapper(BayesPmWrapper bayesPmWrapper, BayesDataWrapper dataWrapper) {
        this(bayesPmWrapper, (DataWrapper)dataWrapper);
    }

    public DirichletBayesImWrapper(DirichletEstimatorWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.dirichletBayesIm = wrapper.getEstimatedBayesIm();
        this.log(this.dirichletBayesIm);
    }

    public static DirichletBayesImWrapper serializableInstance() {
        return new DirichletBayesImWrapper(BayesPmWrapper.serializableInstance(), DirichletBayesImParams.serializableInstance());
    }

    public DirichletBayesIm getDirichletBayesIm() {
        return this.dirichletBayesIm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dirichletBayesIm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.dirichletBayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    private void log(DirichletBayesIm im) {
        TetradLogger.getInstance().log("info", "Dirichlet Bayes IM");
        TetradLogger.getInstance().log("im", im.toString());
    }
}

