/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.bayes.DirichletEstimator;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorParams;
import edu.cmu.tetradapp.model.GraphSource;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DirichletEstimatorWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private DirichletBayesIm dirichletBayesIm;

    public DirichletEstimatorWrapper(DataWrapper dataWrapper, DirichletBayesImWrapper dirichletPriorWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (dirichletPriorWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        DirichletBayesIm dirichletBayesIm = dirichletPriorWrapper.getDirichletBayesIm();
        try {
            this.dirichletBayesIm = DirichletEstimator.estimate(dirichletBayesIm, dataSet);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Please fully specify the Dirichlet prior first.");
        }
        this.log(dirichletBayesIm);
    }

    public DirichletEstimatorWrapper(DataWrapper dataWrapper, DirichletEstimatorWrapper dirichletPriorWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (dirichletPriorWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        DirichletBayesIm dirichletBayesIm = dirichletPriorWrapper.getEstimatedBayesIm();
        try {
            this.dirichletBayesIm = DirichletEstimator.estimate(dirichletBayesIm, dataSet);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Please fully specify the Dirichlet prior first.");
        }
        this.log(dirichletBayesIm);
    }

    public DirichletEstimatorWrapper(DataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper, DirichletEstimatorParams params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (bayesPmWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        DirichletBayesIm dirichletBayesIm = DirichletBayesIm.symmetricDirichletIm(bayesPmWrapper.getBayesPm(), params.getSymmetricAlpha());
        try {
            this.dirichletBayesIm = DirichletEstimator.estimate(dirichletBayesIm, dataSet);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Please fully specify the Dirichlet prior first.");
        }
        this.log(dirichletBayesIm);
    }

    public static DirichletEstimatorWrapper serializableInstance() {
        return new DirichletEstimatorWrapper(DataWrapper.serializableInstance(), DirichletBayesImWrapper.serializableInstance());
    }

    public DirichletBayesIm getEstimatedBayesIm() {
        return this.dirichletBayesIm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dirichletBayesIm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.dirichletBayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(DirichletBayesIm im) {
        TetradLogger.getInstance().log("info", "Estimated Dirichlet Bayes IM");
        TetradLogger.getInstance().log("im", "" + im);
        TetradLogger.getInstance().reset();
    }
}

