/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.gene.graph.ManualActiveLagGraph;
import edu.cmu.tetrad.gene.history.BasalInitializer;
import edu.cmu.tetrad.gene.history.BooleanGlassFunction;
import edu.cmu.tetrad.gene.history.GeneHistory;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.gene.history.PreviousStepOnly;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.BooleanGlassGeneIm;
import edu.cmu.tetradapp.model.BooleanGlassGenePm;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MeasurementSimulatorParams;

public class GeneSimDataWrapper
extends DataWrapper
implements TetradSerializable {
    static final long serialVersionUID = 23L;

    public GeneSimDataWrapper(BooleanGlassGeneIm glassIm, MeasurementSimulatorParams simulator) {
        glassIm.setSimulator(simulator);
        this.setDataModel(glassIm.simulateData());
        LogObjectsUtils.logDataModelList("Data simulated from a gene simulation model.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        ManualActiveLagGraph lagGraph = new ManualActiveLagGraph();
        lagGraph.addFactor("G1");
        lagGraph.addFactor("G2");
        lagGraph.addFactor("G3");
        PreviousStepOnly graphInitializer = new PreviousStepOnly();
        graphInitializer.initialize(lagGraph);
        lagGraph.addEdge("G2", new LaggedFactor("G1", 1));
        lagGraph.addEdge("G3", new LaggedFactor("G1", 1));
        lagGraph.addEdge("G3", new LaggedFactor("G2", 1));
        BooleanGlassFunction updateFunction = new BooleanGlassFunction(lagGraph);
        BasalInitializer historyInitializer = new BasalInitializer(updateFunction, 0.0, 1.0);
        GeneHistory history = new GeneHistory(historyInitializer, updateFunction);
        MeasurementSimulatorParams params = new MeasurementSimulatorParams();
        params.setHistory(history);
        BooleanGlassGenePm pm = new BooleanGlassGenePm(lagGraph);
        BooleanGlassGeneIm im = new BooleanGlassGeneIm(pm);
        return new GeneSimDataWrapper(im, params);
    }
}

