/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class GeneralizedSemPmWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private final GeneralizedSemPm semPm;
    private boolean showErrors;

    private GeneralizedSemPmWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        if (graph instanceof SemGraph) {
            this.semPm = new GeneralizedSemPm(graph);
        } else {
            try {
                this.semPm = new GeneralizedSemPm(new SemGraph(graph));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(SemPmWrapper pmWrapper) {
        if (pmWrapper == null) {
            throw new NullPointerException();
        }
        this.semPm = new GeneralizedSemPm(pmWrapper.getSemPm());
    }

    public GeneralizedSemPmWrapper(GraphWrapper graphWrapper) {
        this(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public GeneralizedSemPmWrapper(DagWrapper dagWrapper) {
        this(new EdgeListGraph(dagWrapper.getDag()));
    }

    public GeneralizedSemPmWrapper(SemGraphWrapper semGraphWrapper) {
        this(semGraphWrapper.getSemGraph());
    }

    public GeneralizedSemPmWrapper(SemEstimatorWrapper wrapper) {
        try {
            SemPm oldSemPm = wrapper.getSemEstimator().getEstimatedSem().getSemPm();
            this.semPm = new GeneralizedSemPm(oldSemPm);
        }
        catch (Exception e) {
            throw new RuntimeException("SemPm could not be deep cloned.", e);
        }
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(SemImWrapper wrapper) {
        SemPm oldSemPm = wrapper.getSemIm().getSemPm();
        this.semPm = new GeneralizedSemPm(oldSemPm);
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(MimBuildRunner wrapper) {
        SemPm oldSemPm = wrapper.getSemPm();
        this.semPm = new GeneralizedSemPm(oldSemPm);
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(BuildPureClustersRunner wrapper) {
        Graph graph = wrapper.getResultGraph();
        if (graph == null) {
            throw new IllegalArgumentException("No graph to display.");
        }
        SemPm oldSemPm = new SemPm(graph);
        this.semPm = new GeneralizedSemPm(oldSemPm);
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(AlgorithmRunner wrapper) {
        this(new EdgeListGraph(wrapper.getResultGraph()));
    }

    public static GeneralizedSemPmWrapper serializableInstance() {
        return new GeneralizedSemPmWrapper(Dag.serializableInstance());
    }

    public GeneralizedSemPm getSemPm() {
        return this.semPm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semPm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.semPm.getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    private void log(GeneralizedSemPm pm) {
        TetradLogger.getInstance().log("info", "Generalized Structural Equation Parameter Model (Generalized SEM PM)");
        TetradLogger.getInstance().log("pm", pm.toString());
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

