/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetradapp.model.GesParams;
import edu.cmu.tetradapp.model.IndTestParams;
import java.io.IOException;
import java.io.ObjectInputStream;

public class GesIndTestParams
implements IndTestParams {
    static final long serialVersionUID = 23L;
    private double structurePrior;
    private double cellPrior;
    private boolean uniformStructurePrior;
    private GesParams originalParams;
    private double alpha = 0.05;
    private int depth = -1;
    private double minimalImprovement;
    private double penaltyDiscount = 1.0;
    private double commplexityPenalty = 0.0;
    private int numPatternsToSave = 1;

    public GesIndTestParams(double cellPrior, double structurePrior, GesParams originalParams) {
        if (originalParams == null) {
            throw new NullPointerException();
        }
        this.setCellPrior(cellPrior);
        this.setStructurePrior(structurePrior);
        this.originalParams = originalParams;
    }

    public static GesIndTestParams serializableInstance() {
        return new GesIndTestParams(0.5, 0.5, GesParams.serializableInstance());
    }

    public double getCellPrior() {
        return this.cellPrior;
    }

    public void setCellPrior(double cellPrior) {
        if (cellPrior < 0.0) {
            throw new IllegalArgumentException("Should be non-negative.");
        }
        this.cellPrior = cellPrior;
    }

    public double getStructurePrior() {
        return this.structurePrior;
    }

    public void setStructurePrior(double structurePrior) {
        if (structurePrior < 0.0) {
            throw new IllegalArgumentException("Should be non-negative.");
        }
        this.structurePrior = structurePrior;
    }

    public Knowledge getKnowledge() {
        return this.originalParams.getKnowledge();
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (!(alpha >= 0.0) || !(alpha <= 1.0)) {
            throw new IllegalArgumentException("Alpha out of range: " + alpha);
        }
        this.alpha = alpha;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int getNumLags() {
        throw new UnsupportedOperationException();
    }

    public void setNumLags(int numLags) {
        throw new UnsupportedOperationException();
    }

    public int getNumTimePoints() {
        throw new UnsupportedOperationException();
    }

    public void setNumTimePoints(int numTimePoints) {
        throw new UnsupportedOperationException();
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public boolean isTimeSeries() {
        return false;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.originalParams == null) {
            throw new NullPointerException();
        }
        if (this.depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        if (!(this.alpha >= 0.0) || !(this.alpha <= 1.0)) {
            throw new IllegalArgumentException("Alpha out of range: " + this.alpha);
        }
        if (this.depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        if (this.penaltyDiscount == 0.0 && this.commplexityPenalty > 0.0) {
            this.penaltyDiscount = this.commplexityPenalty;
            this.commplexityPenalty = 0.0;
        }
    }

    public int getNumPatternsToSave() {
        return this.numPatternsToSave;
    }

    public void setNumPatternsToSave(int numPatternsToSave) {
        if (numPatternsToSave < 1) {
            throw new IllegalArgumentException("Must save at least 1 pattern.");
        }
        this.numPatternsToSave = numPatternsToSave;
    }
}

