/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.GraphComparisonParams;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;

public final class GraphComparison
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private GraphComparisonParams params;
    private final Graph targetGraph;
    private final Graph referenceGraph;
    private Graph trueGraph;
    private int numMissingEdges;
    private int numCorrectEdges;
    private int commissionErrors;
    private int adjCorrect;
    private int adjFp;
    private int adjFn;
    private int arrowptCorrect;
    private int arrowptFp;
    private int arrowptFn;
    private int arrowptAfp;
    private int arrowptAfn;
    private List<Edge> edgesAdded;
    private List<Edge> edgesRemoved;
    private List<Edge> edgesReorientedFrom;
    private List<Edge> edgesReorientedTo;

    public GraphComparison(SessionModel model1, SessionModel model2, GraphComparisonParams params) {
        if (params == null) {
            throw new NullPointerException("Params must not be null");
        }
        if (model2 == null) {
            model2 = new DagWrapper(new Dag());
        }
        if (model1 == null) {
            model1 = new DagWrapper(new Dag());
        }
        if (!(model1 instanceof GraphSource) || !(model2 instanceof GraphSource)) {
            throw new IllegalArgumentException("Must be graph sources.");
        }
        this.params = params;
        String referenceName = this.params.getReferenceGraphName();
        if (referenceName == null) {
            this.referenceGraph = ((GraphSource)((Object)model1)).getGraph();
            this.targetGraph = ((GraphSource)((Object)model2)).getGraph();
            this.params.setReferenceGraphName(model1.getName());
        } else if (referenceName.equals(model1.getName())) {
            this.referenceGraph = ((GraphSource)((Object)model1)).getGraph();
            this.targetGraph = ((GraphSource)((Object)model2)).getGraph();
        } else if (referenceName.equals(model2.getName())) {
            this.referenceGraph = ((GraphSource)((Object)model2)).getGraph();
            this.targetGraph = ((GraphSource)((Object)model1)).getGraph();
        } else {
            throw new IllegalArgumentException("Neither of the supplied session models is named '" + referenceName + "'.");
        }
        Graph alteredRefGraph = this.params != null && this.params.isKeepLatents() ? this.referenceGraph : GraphComparison.removeLatent(this.referenceGraph);
        GraphUtils.GraphComparison comparison = GraphUtils.getGraphComparison(this.targetGraph, alteredRefGraph);
        this.adjFn = comparison.getAdjFn();
        this.adjFp = comparison.getAdjFp();
        this.adjCorrect = comparison.getAdjCorrect();
        this.arrowptFn = comparison.getArrowptFn();
        this.arrowptFp = comparison.getArrowptFp();
        this.arrowptCorrect = comparison.getArrowptCorrect();
        this.edgesAdded = comparison.getEdgesAdded();
        this.edgesRemoved = comparison.getEdgesRemoved();
        this.edgesReorientedFrom = comparison.getEdgesReorientedFrom();
        this.edgesReorientedTo = comparison.getEdgesReorientedTo();
        if (this.params != null) {
            this.params.addRecord(this.getAdjCorrect(), this.getAdjFn(), this.getAdjFp(), this.getArrowptCorrect(), this.getArrowptFn(), this.getArrowptFp());
        }
        TetradLogger.getInstance().log("info", "Graph Comparison");
        TetradLogger.getInstance().log("comparison", this.getCompareString());
    }

    public GraphComparison(GraphWrapper referenceGraph, AbstractAlgorithmRunner algorithmRunner, GraphComparisonParams params) {
        this((SessionModel)referenceGraph, (SessionModel)algorithmRunner, params);
    }

    public GraphComparison(GraphWrapper referenceWrapper, GraphWrapper targetWrapper, GraphComparisonParams params) {
        this((SessionModel)referenceWrapper, (SessionModel)targetWrapper, params);
    }

    public GraphComparison(DagWrapper referenceGraph, AbstractAlgorithmRunner algorithmRunner, GraphComparisonParams params) {
        this((SessionModel)referenceGraph, (SessionModel)algorithmRunner, params);
    }

    public GraphComparison(DagWrapper referenceWrapper, GraphWrapper targetWrapper, GraphComparisonParams params) {
        this((SessionModel)referenceWrapper, (SessionModel)targetWrapper, params);
    }

    public GraphComparison(Graph referenceGraph, Graph targetGraph) {
        this.referenceGraph = referenceGraph;
        this.targetGraph = targetGraph;
        Graph alteredRefGraph = this.params != null && this.params.isKeepLatents() ? this.referenceGraph : GraphComparison.removeLatent(this.targetGraph);
        GraphUtils.GraphComparison comparison = GraphUtils.getGraphComparison(this.targetGraph, alteredRefGraph);
        this.adjFn = comparison.getAdjFn();
        this.adjFp = comparison.getAdjFp();
        this.adjCorrect = comparison.getAdjCorrect();
        this.arrowptFn = comparison.getArrowptFn();
        this.arrowptFp = comparison.getArrowptFp();
        this.arrowptCorrect = comparison.getArrowptCorrect();
        this.edgesAdded = comparison.getEdgesAdded();
        this.edgesRemoved = comparison.getEdgesRemoved();
        this.edgesReorientedFrom = comparison.getEdgesReorientedFrom();
        this.edgesReorientedTo = comparison.getEdgesReorientedTo();
        if (this.params != null) {
            this.params.addRecord(this.getAdjCorrect(), this.getAdjFn(), this.getAdjFp(), this.getArrowptCorrect(), this.getArrowptFn(), this.getArrowptFp());
        }
        TetradLogger.getInstance().log("info", "Graph Comparison");
        TetradLogger.getInstance().log("comparison", this.getCompareString());
    }

    public GraphComparison(Graph referenceGraph, Graph targetGraph, Graph trueGraph) {
        this.referenceGraph = referenceGraph;
        this.targetGraph = targetGraph;
        this.trueGraph = trueGraph;
        Graph alteredRefGraph = this.params != null && this.params.isKeepLatents() ? this.referenceGraph : GraphComparison.removeLatent(this.targetGraph);
        GraphUtils.GraphComparison comparison = GraphUtils.getGraphComparison(this.targetGraph, alteredRefGraph);
        this.adjFn = comparison.getAdjFn();
        this.adjFp = comparison.getAdjFp();
        this.adjCorrect = comparison.getAdjCorrect();
        this.arrowptFn = comparison.getArrowptFn();
        this.arrowptFp = comparison.getArrowptFp();
        this.arrowptCorrect = comparison.getArrowptCorrect();
        this.edgesAdded = comparison.getEdgesAdded();
        this.edgesRemoved = comparison.getEdgesRemoved();
        this.edgesReorientedFrom = comparison.getEdgesReorientedFrom();
        this.edgesReorientedTo = comparison.getEdgesReorientedTo();
        if (this.params != null) {
            this.params.addRecord(this.getAdjCorrect(), this.getAdjFn(), this.getAdjFp(), this.getArrowptCorrect(), this.getArrowptFn(), this.getArrowptFp());
        }
        TetradLogger.getInstance().log("info", "Graph Comparison");
        TetradLogger.getInstance().log("comparison", this.getCompareString());
    }

    public static GraphComparison serializableInstance() {
        return new GraphComparison((SessionModel)DagWrapper.serializableInstance(), DagWrapper.serializableInstance(), GraphComparisonParams.serializableInstance());
    }

    public DataSet getDataSet() {
        return this.params.getDataSet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public List<Edge> getEdgesAdded() {
        return this.edgesAdded;
    }

    public List<Edge> getEdgesRemoved() {
        return this.edgesRemoved;
    }

    public List<Edge> getEdgesReorientedFrom() {
        return this.edgesReorientedFrom;
    }

    public List<Edge> getEdgesReorientedTo() {
        return this.edgesReorientedTo;
    }

    public String toString() {
        return "Errors of omission = " + this.getAdjFn() + ", Errors of commission = " + this.getAdjFp();
    }

    public String getCompareString() {
        Edge edge;
        int i;
        StringBuilder builder = new StringBuilder();
        String trueGraphAndTarget = "Comparing " + this.getParams().getReferenceGraphName() + " to " + this.getParams().getTargetGraphName();
        builder.append(trueGraphAndTarget + "\n");
        builder.append("\nEdges added:");
        if (this.getEdgesAdded().isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            List<Edge> edgesAdded = this.getEdgesAdded();
            for (i = 0; i < edgesAdded.size(); ++i) {
                edge = edgesAdded.get(i);
                builder.append("\n").append(i + 1).append(". ").append(edge);
            }
        }
        builder.append("\n\nEdge removed:");
        if (this.getEdgesRemoved().isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            List<Edge> edgesRemoved = this.getEdgesRemoved();
            for (i = 0; i < edgesRemoved.size(); ++i) {
                edge = edgesRemoved.get(i);
                builder.append("\n" + (i + 1) + ". ").append(edge);
            }
        }
        builder.append("\n\nEdges reoriented:");
        if (this.getEdgesReorientedFrom().isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            List<Edge> edgeReorientedFrom = this.getEdgesReorientedFrom();
            List<Edge> edgesReorientedTo = this.getEdgesReorientedTo();
            for (int i2 = 0; i2 < this.getEdgesReorientedFrom().size(); ++i2) {
                Edge from = edgeReorientedFrom.get(i2);
                Edge to = edgesReorientedTo.get(i2);
                builder.append("\n").append(i2 + 1).append(". ").append(from).append(" ====> ").append(to);
            }
        }
        String compareString = builder.toString();
        return compareString;
    }

    public Graph getTargetGraph() {
        return new EdgeListGraph(this.targetGraph);
    }

    public Graph getReferenceGraph() {
        return new EdgeListGraph(this.referenceGraph);
    }

    private static Graph removeLatent(Graph g) {
        EdgeListGraph result = new EdgeListGraph(g);
        result.setGraphConstraintsChecked(false);
        List<Node> allNodes = g.getNodes();
        LinkedList<Node> toBeRemoved = new LinkedList<Node>();
        for (Node curr : allNodes) {
            if (curr.getNodeType() != NodeType.LATENT) continue;
            List<Node> adj = result.getAdjacentNodes(curr);
            for (int i = 0; i < adj.size(); ++i) {
                Node a = adj.get(i);
                for (int j = i + 1; j < adj.size(); ++j) {
                    Node b = adj.get(j);
                    if (result.isAdjacentTo(a, b)) continue;
                    result.addEdge(Edges.undirectedEdge(a, b));
                }
            }
            toBeRemoved.add(curr);
        }
        result.removeNodes(toBeRemoved);
        return result;
    }

    private int getAdjCorrect() {
        return this.adjCorrect;
    }

    private int getAdjFn() {
        return this.adjFn;
    }

    private int getAdjFp() {
        return this.adjFp;
    }

    private int getArrowptCorrect() {
        return this.arrowptCorrect;
    }

    private int getArrowptFn() {
        return this.arrowptFn;
    }

    private int getArrowptFp() {
        return this.arrowptFp;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.params == null) {
            throw new NullPointerException();
        }
        if (this.targetGraph == null) {
            throw new NullPointerException();
        }
        if (this.referenceGraph == null) {
            throw new NullPointerException();
        }
        if (this.getAdjCorrect() < 0) {
            throw new IllegalArgumentException();
        }
        if (this.getAdjFn() < 0) {
            throw new IllegalArgumentException();
        }
        if (this.getAdjFp() < 0) {
            throw new IllegalArgumentException();
        }
    }

    public Graph getTrueGraph() {
        return this.trueGraph;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }

    public GraphComparisonParams getParams() {
        return this.params;
    }
}

