/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.model.Params;
import java.io.IOException;
import java.io.ObjectInputStream;

public class LagGraphParams
implements Params {
    static final long serialVersionUID = 23L;
    public static final int CONSTANT = 0;
    public static final int MAX = 1;
    public static final int MEAN = 2;
    private int indegreeType = 0;
    private int varsPerInd = 5;
    private int mlag = 1;
    private int indegree = 2;
    private double percentUnregulated = 10.0;

    public static LagGraphParams serializableInstance() {
        return new LagGraphParams();
    }

    public int getVarsPerInd() {
        return this.varsPerInd;
    }

    public void setVarsPerInd(int varsPerInd) {
        if (varsPerInd > 0) {
            this.varsPerInd = varsPerInd;
        }
    }

    public int getMlag() {
        return this.mlag;
    }

    public void setMlag(int mlag) {
        if (mlag > 0) {
            this.mlag = mlag;
        }
    }

    public int getIndegree() {
        return this.indegree;
    }

    public void setIndegree(int indegree) {
        if (indegree > 1) {
            this.indegree = indegree;
        }
    }

    public int getIndegreeType() {
        return this.indegreeType;
    }

    public void setIndegreeType(int indegreeType) {
        switch (indegreeType) {
            case 0: 
            case 1: 
            case 2: {
                this.indegreeType = indegreeType;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public double getPercentUnregulated() {
        return this.percentUnregulated;
    }

    public void setPercentUnregulated(double percentUnregulated) {
        if (percentUnregulated < 0.0 || percentUnregulated > 100.0) {
            throw new IllegalArgumentException();
        }
        this.percentUnregulated = percentUnregulated;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        switch (this.indegreeType) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Illegal indegree type: " + this.indegreeType);
            }
        }
        if (this.varsPerInd < 1) {
            throw new IllegalStateException("VarsPerInd out of range: " + this.varsPerInd);
        }
        if (this.mlag <= 0) {
            throw new IllegalStateException("Mlag out of range: " + this.mlag);
        }
        if (this.varsPerInd <= 1) {
            throw new IllegalStateException("VarsPerInd out of range: " + this.varsPerInd);
        }
        if (!(this.percentUnregulated > 0.0) || !(this.percentUnregulated < 100.0)) {
            throw new IllegalStateException("PercentUnregulated out of range: " + this.percentUnregulated);
        }
    }
}

