/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetradapp.model.IndTestParams;
import java.io.IOException;
import java.io.ObjectInputStream;

public class LagIndTestParams
implements IndTestParams {
    static final long serialVersionUID = 23L;
    private double alpha = 0.05;
    private int depth = -1;
    private int numTimePoints = 2;
    private int numLags = 1;

    public static LagIndTestParams serializableInstance() {
        return new LagIndTestParams();
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha out of range: " + alpha);
        }
        this.alpha = alpha;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int getNumLags() {
        return this.numLags;
    }

    public void setNumLags(int numLags) {
        if (numLags < 1 || numLags > this.getNumTimePoints() - 1) {
            throw new IllegalArgumentException("NumLags must be in [1, , numTimePoints - 1]: " + numLags);
        }
        this.numLags = numLags;
    }

    public int getNumTimePoints() {
        return this.numTimePoints;
    }

    public void setNumTimePoints(int numTimePoints) {
        if (numTimePoints < 2) {
            throw new IllegalArgumentException("NumTimePoints out of range: " + numTimePoints);
        }
        this.numTimePoints = numTimePoints;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.alpha < 0.0 && this.alpha > 1.0) {
            throw new IllegalArgumentException("Alpha shoulb be in [0, 1]: " + this.alpha);
        }
        if (this.depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1: " + this.depth);
        }
        if (this.numTimePoints < 2) {
            throw new IllegalArgumentException("NumTimePoints out of range: " + this.numTimePoints);
        }
        if (this.numLags < 1 || this.numLags > this.getNumTimePoints() - 1) {
            throw new IllegalArgumentException("NumLags must be in [1, , numTimePoints - 1]: " + this.numLags);
        }
    }
}

