/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetradapp.model.BuildPureClustersParams;
import edu.cmu.tetradapp.model.MimIndTestParams;
import edu.cmu.tetradapp.model.MimParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class PurifyIndTestParams
implements MimIndTestParams {
    static final long serialVersionUID = 23L;
    private double alpha = 5.0E-5;
    private int numClusters;
    private TestType _tetradTestType;
    private int tetradTestType;
    private MimParams originalParams;
    private List<String> varNames;

    public PurifyIndTestParams(double alpha, int numClusters, TestType testType, MimParams originalParams) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha out of range: " + alpha);
        }
        if (numClusters < 1) {
            throw new IllegalArgumentException("Number of clusters should be >= 1: " + numClusters);
        }
        this.alpha = alpha;
        this.numClusters = numClusters;
        this._tetradTestType = testType;
        this.originalParams = originalParams;
    }

    public static PurifyIndTestParams serializableInstance() {
        return new PurifyIndTestParams(5.0E-5, 2, TestType.TETRAD_BOLLEN, BuildPureClustersParams.serializableInstance());
    }

    public TestType getTetradTestType() {
        return this._tetradTestType;
    }

    public void setTetradTestType(TestType type) {
        this._tetradTestType = type;
    }

    public Clusters getClusters() {
        return this.originalParams.getClusters();
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha out of range: " + alpha);
        }
        this.alpha = alpha;
    }

    @Override
    public List<String> getVarNames() {
        return this.varNames;
    }

    @Override
    public void setVarNames(List<String> varNames) {
        this.varNames = varNames;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.alpha < 0.0 || this.alpha > 1.0) {
            throw new IllegalStateException("Alpha out of range: " + this.alpha);
        }
        if (this.numClusters < 1) {
            throw new IllegalStateException("NumClusters out of range: " + this.numClusters);
        }
    }
}

