/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.ManipulatingBayesUpdater;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.bayes.RowSummingExactUpdater;
import edu.cmu.tetrad.bayes.UpdaterParams;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.model.UpdaterWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;

public class RowSummingExactWrapper
implements SessionModel,
UpdaterWrapper,
Unmarshallable {
    static final long serialVersionUID = 23L;
    private ManipulatingBayesUpdater bayesUpdater;
    private String name;
    private UpdaterParams params;

    public RowSummingExactWrapper(BayesImWrapper wrapper, UpdaterParams params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        BayesIm bayesIm = wrapper.getBayesIm();
        this.setup(bayesIm, params);
    }

    public RowSummingExactWrapper(DirichletBayesImWrapper wrapper, UpdaterParams params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        DirichletBayesIm bayesIm = wrapper.getDirichletBayesIm();
        this.setup(bayesIm, params);
    }

    public RowSummingExactWrapper(BayesEstimatorWrapper wrapper, UpdaterParams params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        BayesIm bayesIm = wrapper.getEstimatedBayesIm();
        this.setup(bayesIm, params);
    }

    public RowSummingExactWrapper(DirichletEstimatorWrapper wrapper, UpdaterParams params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        DirichletBayesIm bayesIm = wrapper.getEstimatedBayesIm();
        this.setup(bayesIm, params);
    }

    public static RowSummingExactWrapper serializableInstance() {
        return new RowSummingExactWrapper(BayesImWrapper.serializableInstance(), new UpdaterParams());
    }

    @Override
    public ManipulatingBayesUpdater getBayesUpdater() {
        return this.bayesUpdater;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void setup(BayesIm bayesIm, UpdaterParams params) {
        TetradLogger.getInstance().setConfigForClass(this.getClass());
        this.params = params;
        this.bayesUpdater = params.getEvidence() == null || !params.getEvidence().isCompatibleWith(bayesIm) ? new RowSummingExactUpdater(bayesIm) : new RowSummingExactUpdater(bayesIm, params.getEvidence());
        Node node = this.getParams().getVariable();
        if (node != null) {
            int i;
            NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
            TetradLogger.getInstance().log("info", "\nRow Summing Exact Updater");
            String nodeName = node.getName();
            int nodeIndex = bayesIm.getNodeIndex(bayesIm.getNode(nodeName));
            double[] priors = this.getBayesUpdater().calculatePriorMarginals(nodeIndex);
            double[] marginals = this.getBayesUpdater().calculateUpdatedMarginals(nodeIndex);
            TetradLogger.getInstance().log("details", "\nVariable = " + nodeName);
            TetradLogger.getInstance().log("details", "\nEvidence:");
            Evidence evidence = this.getParams().getEvidence();
            Proposition proposition = evidence.getProposition();
            for (i = 0; i < proposition.getNumVariables(); ++i) {
                Node variable = proposition.getVariableSource().getVariables().get(i);
                int category = proposition.getSingleCategory(i);
                if (category == -1) continue;
                TetradLogger.getInstance().log("details", "\t" + variable + " = " + category);
            }
            TetradLogger.getInstance().log("details", "\nCat.\tPrior\tMarginal");
            for (i = 0; i < priors.length; ++i) {
                TetradLogger.getInstance().log("details", this.category(evidence, nodeName, i) + "\t" + nf.format(priors[i]) + "\t" + nf.format(marginals[i]));
            }
        }
        TetradLogger.getInstance().reset();
    }

    private String category(Evidence evidence, String nodeName, int i) {
        DiscreteVariable variable = this.discreteVariable(evidence, nodeName);
        return variable.getCategory(i);
    }

    private DiscreteVariable discreteVariable(Evidence evidence, String nodeName) {
        return evidence.getVariable(nodeName);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getBayesUpdater() == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public UpdaterParams getParams() {
        return this.params;
    }
}

