/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.SemPm2;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Sem2PmWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private final SemPm2 semPm2;

    private Sem2PmWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        if (graph instanceof SemGraph) {
            this.semPm2 = new SemPm2(graph);
        } else {
            try {
                this.semPm2 = new SemPm2(new SemGraph(graph));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.log(this.semPm2);
    }

    public Sem2PmWrapper(GraphWrapper graphWrapper) {
        this(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public Sem2PmWrapper(DagWrapper dagWrapper) {
        this(new EdgeListGraph(dagWrapper.getDag()));
    }

    public Sem2PmWrapper(SemGraphWrapper semGraphWrapper) {
        this(semGraphWrapper.getSemGraph());
    }

    public Sem2PmWrapper(AlgorithmRunner wrapper) {
        this(new EdgeListGraph(wrapper.getResultGraph()));
    }

    public static Sem2PmWrapper serializableInstance() {
        return new Sem2PmWrapper(Dag.serializableInstance());
    }

    public SemPm2 getSemPm2() {
        return this.semPm2;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semPm2 == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.semPm2.getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(SemPm2 pm) {
        TetradLogger.getInstance().log("info", "PM type = SEM");
        TetradLogger.getInstance().log("pm", pm.toString());
    }
}

