/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.model.HasCalculatorParams;
import edu.cmu.tetradapp.model.calculator.CalculatorParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.prefs.Preferences;

public class SemDataParams
implements Params,
HasCalculatorParams {
    static final long serialVersionUID = 23L;
    private int sampleSize = 1000;
    private boolean includeLatents = false;
    private boolean positiveDataOnly = false;
    private CalculatorParams calculatorParams = new CalculatorParams();

    public static SemDataParams serializableInstance() {
        return new SemDataParams();
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.sampleSize = sampleSize;
        Preferences.userRoot().putInt("sampleSize", sampleSize);
    }

    public boolean isIncludeLatents() {
        return this.includeLatents;
    }

    public void setIncludeLatents(boolean includeLatents) {
        this.includeLatents = includeLatents;
    }

    public void setPositiveDataOnly(boolean positiveDataOnly) {
        this.positiveDataOnly = positiveDataOnly;
    }

    public boolean isPositiveDataOnly() {
        return this.positiveDataOnly;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sampleSize < 1) {
            throw new IllegalStateException("Sample size < 1: " + this.sampleSize);
        }
    }

    @Override
    public CalculatorParams getCalculatorParams() {
        return this.calculatorParams;
    }
}

