/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SessionNodeWrapper
extends GraphNode
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private SessionNode sessionNode;
    private String buttonType = "???";

    public SessionNodeWrapper(SessionNode sessionNode) {
        super(sessionNode.getDisplayName());
        this.sessionNode = sessionNode;
        this.setNodeType(NodeType.SESSION);
    }

    public static GraphNode serializableInstance() {
        return new SessionNodeWrapper(SessionNode.serializableInstance());
    }

    public String getSessionName() {
        return this.sessionNode.getDisplayName();
    }

    public void setSessionName(String name) {
        if (this.sessionNode != null) {
            super.setName(name);
            this.sessionNode.setDisplayName(name);
        }
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(String buttonType) {
        if (buttonType == null) {
            throw new NullPointerException("Button type cannot be null.");
        }
        this.buttonType = buttonType;
    }

    public SessionNode getSessionNode() {
        return this.sessionNode;
    }

    public int getRepetition() {
        return this.sessionNode.getRepetition();
    }

    public void setRepetition(int repetition) {
        this.sessionNode.setRepetition(repetition);
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public String toString() {
        return "SessionNodewrapper (type " + this.getButtonType() + ", name " + this.getSessionName() + ")";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sessionNode == null) {
            throw new NullPointerException();
        }
        if (this.buttonType == null) {
            throw new NullPointerException();
        }
        this.setNodeType(NodeType.SESSION);
    }
}

