/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.Shimizu2006SearchOld;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.util.LinkedList;
import java.util.List;

public class ShimizuRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public ShimizuRunner(DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public static ShimizuRunner serializableInstance() {
        return new ShimizuRunner(DataWrapper.serializableInstance(), PcSearchParams.serializableInstance(), KnowledgeBoxModel.serializableInstance());
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    @Override
    public void execute() {
        DataModel source = this.getDataModel();
        if (!(source instanceof DataSet)) {
            throw new IllegalArgumentException("Must be a rectangular data set.");
        }
        DataSet dataSet = (DataSet)source;
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Must be continuous.");
        }
        GraphWithParameters result = Shimizu2006SearchOld.lingamDiscovery_DAG(dataSet, 0.05);
        System.out.println(result);
        Graph graph = result.getGraph();
        this.setResultGraph(graph);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = this.getParams().getIndTestType();
        return new IndTestFactory().getTest(dataModel, this.getParams(), testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    private boolean isAggressivelyPreventCycles() {
        SearchParams params = this.getParams();
        if (params instanceof MeekSearchParams) {
            return ((MeekSearchParams)params).isAggressivelyPreventCycles();
        }
        return false;
    }
}

