/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.model.DataWrapper;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDataWrapper
extends TestCase {
    DataWrapper dataWrapper;

    public TestDataWrapper(String name) {
        super(name);
    }

    public void testConstruction() {
        this.dataWrapper = new DataWrapper();
        TestDataWrapper.assertNotNull(this.dataWrapper);
    }

    public void testDataModelList() {
        DataModelList modelList = new DataModelList();
        ArrayList<Node> variables1 = new ArrayList<Node>();
        for (int i = 0; i < 10; ++i) {
            variables1.add(new ContinuousVariable("X" + i));
        }
        ArrayList<Node> variables2 = new ArrayList<Node>();
        for (int i = 0; i < 10; ++i) {
            variables2.add(new ContinuousVariable("X" + i));
        }
        ColtDataSet first = new ColtDataSet(10, variables1);
        first.setName("first");
        ColtDataSet second = new ColtDataSet(10, variables2);
        second.setName("second");
        modelList.add(first);
        modelList.add(second);
        System.out.println(modelList.contains(first));
        System.out.println(modelList.contains(second));
        modelList.setSelectedModel(second);
        try {
            DataModelList modelList2 = new MarshalledObject<DataModelList>(modelList).get();
            System.out.println(modelList2.getSelectedModel().getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestDataWrapper.class);
    }
}

