/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.calculator.CalculatorParams;
import edu.cmu.tetradapp.model.calculator.Transformation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;

public class CalculatorWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CalculatorWrapper(DataWrapper data, CalculatorParams params) {
        String[] displayEquations;
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        if (params == null) {
            throw new NullPointerException("The given parameters must not be null");
        }
        DataSet copy = CalculatorWrapper.copy((DataSet)data.getSelectedDataModel());
        ArrayList<String> equations = new ArrayList<String>();
        int size = params.getEquations().size();
        for (String equation : displayEquations = params.getEquations().toArray(new String[size])) {
            if (equation.contains("$")) {
                for (Node node : copy.getVariables()) {
                    equations.add(equation.replace("$", node.getName()));
                }
                continue;
            }
            equations.add(equation);
        }
        if (!equations.isEmpty()) {
            try {
                Transformation.transform(copy, equations.toArray(new String[equations.size()]));
            }
            catch (ParseException e) {
                throw new IllegalStateException("Was given unparsable expressions.");
            }
            this.setDataModel(copy);
        } else {
            this.setDataModel(copy);
        }
        this.setSourceGraph(data.getSourceGraph());
    }

    public static CalculatorWrapper serializableInstance() {
        return new CalculatorWrapper(DataWrapper.serializableInstance(), CalculatorParams.serializableInstance());
    }

    private static DataSet copy(DataSet data) {
        if (data instanceof ColtDataSet) {
            return new ColtDataSet((ColtDataSet)data);
        }
        ColtDataSet copy = new ColtDataSet(data.getNumRows(), data.getVariables());
        int cols = data.getNumColumns();
        int rows = data.getNumRows();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                copy.setDouble(row, col, data.getDouble(row, col));
            }
        }
        return copy;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

