/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator.expression;

import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class AbstractExpression
implements Expression {
    static final long serialVersionUID = 23L;
    private final List<Expression> expressions;
    private ExpressionDescriptor.Position position;
    private String token;

    public AbstractExpression(Expression ... expressions) {
        this.expressions = Arrays.asList(expressions);
    }

    public AbstractExpression(String token, ExpressionDescriptor.Position position, Expression ... expressions) {
        this.position = position;
        this.token = token;
        this.expressions = Collections.unmodifiableList(Arrays.asList(expressions));
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public ExpressionDescriptor.Position getPosition() {
        return this.position;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public String toString() {
        if (this.getPosition() != null && this.getToken() != null) {
            return ExpressionUtils.renderExpression(this, this.getPosition(), this.getToken());
        }
        return "No string representation available.";
    }
}

