/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator.parser;

import edu.cmu.tetradapp.model.calculator.expression.ConstantExpression;
import edu.cmu.tetradapp.model.calculator.expression.Context;
import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.parser.ExpressionParser;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestParser
extends TestCase {
    public TestParser(String name) {
        super(name);
    }

    public void testInvalidExpressions() {
        ExpressionParser parser = new ExpressionParser();
        TestParser.parseInvalid(parser, "(1 + 3))");
        TestParser.parseInvalid(parser, "(1 + (4 * 5) + sqrt(5)");
        TestParser.parseInvalid(parser, "1+");
        TestParser.parseInvalid(parser, "113#");
    }

    public void testParseEquation() {
        ExpressionParser parser = new ExpressionParser(Arrays.asList("x", "y"), ExpressionParser.RestrictionType.MAY_ONLY_CONTAIN);
        try {
            parser.parseEquation("x = (1 + y)");
        }
        catch (ParseException ex) {
            TestParser.fail(ex.getMessage());
        }
    }

    public void testBasicExpressions() {
        ExpressionParser parser = new ExpressionParser();
        Expression expression = TestParser.parse(parser, "+(1,1)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 2.0);
        expression = TestParser.parse(parser, "*(+(1,2), 5)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 15.0);
        expression = TestParser.parse(parser, "1 + 2.5");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 3.5);
        expression = TestParser.parse(parser, "(2 + 3)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 5.0);
        expression = TestParser.parse(parser, "1 + (3 + 4)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 8.0);
        expression = TestParser.parse(parser, "1 + 2 + 5");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 8.0);
        expression = TestParser.parse(parser, "1 + (2 * 3)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 7.0);
        expression = TestParser.parse(parser, "1 + (2 + (3 * 4))");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 15.0);
        expression = TestParser.parse(parser, "(2 * 3) + (4 * 5)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 26.0);
        expression = TestParser.parse(parser, "((2 * 3) + (1 + (2 + (3 * 4))))");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 21.0);
        expression = TestParser.parse(parser, "pow(2,3)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 8.0);
        expression = TestParser.parse(parser, "sqrt(pow(2,2))");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 2.0);
        expression = TestParser.parse(parser, ConstantExpression.E.getName());
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == ConstantExpression.E.evaluate(null));
        expression = TestParser.parse(parser, ConstantExpression.PI.getName());
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == ConstantExpression.PI.evaluate(null));
        expression = TestParser.parse(parser, ConstantExpression.PI.getName() + "+ 2");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 5.141592653589793);
    }

    public void testVariables() {
        ExpressionParser parser = new ExpressionParser(Arrays.asList("x", "y", "z"), ExpressionParser.RestrictionType.MAY_ONLY_CONTAIN);
        TestingContext context = new TestingContext();
        Expression expression = TestParser.parse(parser, "x");
        context.assign("x", 5.6);
        TestParser.assertTrue(expression.evaluate(context) == 5.6);
        expression = TestParser.parse(parser, "(x + y) * z");
        context.assign("x", 1.0);
        context.assign("y", 2.0);
        context.assign("z", 3.0);
        TestParser.assertTrue(expression.evaluate(context) == 9.0);
        expression = TestParser.parse(parser, "3 + (x + (3 * y))");
        context.assign("x", 4.0);
        context.assign("y", 2.0);
        TestParser.assertTrue(expression.evaluate(context) == 13.0);
    }

    public void testEvaluation() {
        ExpressionParser parser = new ExpressionParser(Arrays.asList("x", "y", "z"), ExpressionParser.RestrictionType.MAY_ONLY_CONTAIN);
        TestingContext context = new TestingContext();
    }

    public void testVariableRestriction() {
        ExpressionParser parser = new ExpressionParser(Arrays.asList("x", "y", "z"), ExpressionParser.RestrictionType.MAY_ONLY_CONTAIN);
        TestParser.parseInvalid(parser, "x + x1");
    }

    public void testCommutativeOperators() {
        ExpressionParser parser = new ExpressionParser();
        Expression expression = TestParser.parse(parser, "1 + 2 + 3");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 6.0);
        expression = TestParser.parse(parser, "1 + 1 + 1 + (3 * 4)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 15.0);
        expression = TestParser.parse(parser, "1 * 1 * 2 * 3 * (1 + 1)");
        TestParser.assertTrue(expression.evaluate(new TestingContext()) == 12.0);
    }

    private static void parseInvalid(ExpressionParser parser, String exp) {
        try {
            Expression e = parser.parseExpression(exp);
            TestParser.fail("Should not have parsed, " + exp + ", but got " + e);
        }
        catch (ParseException ex) {
            System.out.println("Succussfully raised exception with message: ");
            System.out.println(ex.getMessage());
        }
    }

    private static Expression parse(ExpressionParser parser, String expression) {
        System.out.println("Parsing string: " + expression);
        try {
            return parser.parseExpression(expression);
        }
        catch (ParseException ex) {
            int offset = ex.getErrorOffset();
            System.out.println(expression);
            for (int i = 0; i < offset; ++i) {
                System.out.print(" ");
            }
            System.out.println("^");
            ex.printStackTrace();
            TestParser.fail(ex.getMessage());
            return null;
        }
    }

    public static Test suite() {
        return new TestSuite(TestParser.class);
    }

    private static class TestingContext
    implements Context {
        private Map<String, Double> doubleVars = new HashMap<String, Double>();
        private Map<String, Object> vars = new HashMap<String, Object>();

        private TestingContext() {
        }

        public void assign(String v, double d) {
            this.doubleVars.put(v, d);
        }

        public void clear() {
            this.doubleVars.clear();
            this.vars.clear();
        }

        @Override
        public Double getValue(String var) {
            return this.doubleVars.get(var);
        }
    }
}

