/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import java.util.List;

public class CovMatrixWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CovMatrixWrapper(DataWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModel model = wrapper.getSelectedDataModel();
        if (model instanceof DataSet) {
            DataSet dataSet = (DataSet)model;
            if (!dataSet.isContinuous()) {
                throw new IllegalArgumentException("The data must be continuous");
            }
            CovarianceMatrix covarianceMatrix = new CovarianceMatrix(dataSet);
            this.setDataModel(covarianceMatrix);
            this.setSourceGraph(wrapper.getSourceGraph());
        } else if (model instanceof CovarianceMatrix) {
            CovarianceMatrix covarianceMatrix = new CovarianceMatrix((CovarianceMatrix)model);
            this.setDataModel(covarianceMatrix);
            this.setSourceGraph(wrapper.getSourceGraph());
        } else {
            throw new IllegalArgumentException("Must be a dataset or a covariance  matrix");
        }
        LogObjectsUtils.logDataModelList("Conversion of data to covariance matrix form.", this.getDataModelList());
    }

    public CovMatrixWrapper(SemImWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("The Sem IM must not be null.");
        }
        SemIm semIm = wrapper.getSemIm();
        DoubleMatrix2D matrix = semIm.getImplCovarMeas();
        List<Node> variables = semIm.getMeasuredNodes();
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(variables, matrix, 100000);
        this.setDataModel(covarianceMatrix);
        this.setSourceGraph(semIm.getSemPm().getGraph());
        LogObjectsUtils.logDataModelList("Conversion of data to covariance matrix form.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new CovMatrixWrapper(new DataWrapper(DataUtils.continuousSerializableInstance()));
    }
}

