/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.regression.RegressionInterpolator;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;

public class RegressionInterpolatorWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public RegressionInterpolatorWrapper(DataWrapper data) {
        if (data == null) {
            throw new NullPointerException("The givan data must not be null");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("Data must be tabular");
        }
        RegressionInterpolator interpolator = new RegressionInterpolator();
        this.setDataModel(interpolator.filter((DataSet)model));
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Parent data in which missing values have been replaced by regression predictions.", this.getDataModelList());
    }

    public static RegressionInterpolatorWrapper serializableInstance() {
        return new RegressionInterpolatorWrapper(DataWrapper.serializableInstance());
    }
}

